/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="This field is guaranteed not to be set given it's within a switch over a one_of.")
public final class WrongOneof
extends BugChecker
implements BugChecker.SwitchTreeMatcher,
BugChecker.SwitchExpressionTreeMatcher {
    private static final TypePredicate ONE_OF_ENUM = TypePredicates.isDescendantOf((String)"com.google.protobuf.AbstractMessageLite.InternalOneOfEnum");
    private final ConstantExpressions constantExpressions;

    @Inject
    WrongOneof(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        return this.handle(tree.getExpression(), tree.getCases(), state);
    }

    public Description matchSwitchExpression(SwitchExpressionTree tree, VisitorState state) {
        return this.handle(tree.getExpression(), tree.getCases(), state);
    }

    private Description handle(ExpressionTree e, List<? extends CaseTree> cases, VisitorState state) {
        if (!ONE_OF_ENUM.apply(ASTHelpers.getType((Tree)e), state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = ASTHelpers.stripParentheses((ExpressionTree)e);
        if (!(expression instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)expression);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        this.constantExpressions.constantExpression(receiver, state).ifPresent(constantReceiver -> this.processSwitch(expression, cases, (ConstantExpressions.ConstantExpression)constantReceiver, state));
        return Description.NO_MATCH;
    }

    private void processSwitch(ExpressionTree expression, List<? extends CaseTree> cases, ConstantExpressions.ConstantExpression constantReceiver, VisitorState state) {
        ImmutableSet getters = (ImmutableSet)ASTHelpers.enumValues((Symbol.TypeSymbol)ASTHelpers.getType((Tree)expression).tsym).stream().map(WrongOneof::getter).collect(ImmutableSet.toImmutableSet());
        HashSet<String> allowableGetters = new HashSet<String>();
        for (CaseTree caseTree : cases) {
            if (ASTHelpers.isSwitchDefault((CaseTree)caseTree)) break;
            for (ExpressionTree expressionTree : caseTree.getExpressions()) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)expressionTree);
                if (symbol == null) continue;
                allowableGetters.add(WrongOneof.getter(symbol.getSimpleName().toString()));
            }
            this.scanForInvalidGetters((Set<String>)getters, allowableGetters, caseTree, constantReceiver, state);
            if (Reachability.canFallThrough((CaseTree)caseTree)) continue;
            allowableGetters.clear();
        }
    }

    private void scanForInvalidGetters(final Set<String> getters, final Set<String> allowableGetters, CaseTree caseTree, final ConstantExpressions.ConstantExpression receiverSymbolChain, VisitorState state) {
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ WrongOneof this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
                if (receiver == null) {
                    return (Void)super.visitMethodInvocation(methodInvocationTree, null);
                }
                if (!this.this$0.constantExpressions.constantExpression(receiver, this.state).map((Function<ConstantExpressions.ConstantExpression, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Lcom/google/errorprone/bugpatterns/threadsafety/ConstantExpressions$ConstantExpression;)Ljava/lang/Boolean;)((ConstantExpressions.ConstantExpression)receiverSymbolChain)).orElse(false).booleanValue()) {
                    return (Void)super.visitMethodInvocation(methodInvocationTree, null);
                }
                String methodName = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier().toString();
                if (!allowableGetters.contains(methodName) && getters.contains(methodName)) {
                    this.state.reportMatch(this.this$0.buildDescription(methodInvocationTree).setMessage(String.format("%s is guaranteed to return the default instance, given this is within a switch over a one_of.", methodName)).build());
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, null);
            }
        }.scan(new TreePath(state.getPath(), caseTree), null);
    }

    private static String getter(String enumCase) {
        return "get" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumCase);
    }
}

