/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This method reference is unnecessary, and can be replaced with the variable itself.")
public final class UnnecessaryMethodReference
extends BugChecker
implements BugChecker.MemberReferenceTreeMatcher {
    private static final ImmutableList<KnownAlias> KNOWN_ALIASES = ImmutableList.of((Object)KnownAlias.create((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.base.Predicate").named("apply"), (Supplier<Type>)Suppliers.typeFromString((String)"java.util.function.Predicate")), (Object)KnownAlias.create((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.base.Converter").named("convert"), (Supplier<Type>)Suppliers.typeFromString((String)"com.google.common.base.Function")), (Object)KnownAlias.create((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.collect.Range").named("contains"), (Supplier<Type>)Suppliers.typeFromString((String)"com.google.common.base.Predicate")));

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        IdentifierTree identifierTree;
        if (!tree.getMode().equals((Object)MemberReferenceTree.ReferenceMode.INVOKE)) {
            return Description.NO_MATCH;
        }
        TargetType targetType = TargetType.targetType((VisitorState)state);
        if (targetType == null) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        if (receiver instanceof IdentifierTree && (identifierTree = (IdentifierTree)receiver).getName().contentEquals("super")) {
            return Description.NO_MATCH;
        }
        if (!state.getTypes().isSubtype(ASTHelpers.getType((Tree)receiver), targetType.type())) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        Scope.WriteableScope members = targetType.type().tsym.members();
        if (!members.anyMatch(sym -> UnnecessaryMethodReference.isFunctionalInterfaceInvocation(symbol, targetType.type(), sym, state)) && !UnnecessaryMethodReference.isKnownAlias(tree, targetType.type(), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)receiver), (int)state.getEndPosition((Tree)tree), (String)""));
    }

    private static boolean isFunctionalInterfaceInvocation(Symbol.MethodSymbol memberReferenceTarget, Type type, Symbol symbol, VisitorState state) {
        return (memberReferenceTarget.equals(symbol) || ASTHelpers.findSuperMethodInType((Symbol.MethodSymbol)memberReferenceTarget, (Type)type, (Types)state.getTypes()) != null) && symbol.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isKnownAlias(MemberReferenceTree tree, Type type, VisitorState state) {
        return KNOWN_ALIASES.stream().anyMatch(k -> k.matcher().matches((Tree)tree, state) && ASTHelpers.isSubtype((Type)((Type)k.targetType().get(state)), (Type)type, (VisitorState)state));
    }

    private record KnownAlias(Matcher<ExpressionTree> matcher, Supplier<Type> targetType) {
        static KnownAlias create(Matcher<ExpressionTree> matcher, Supplier<Type> targetType) {
            return new KnownAlias(matcher, targetType);
        }
    }
}

