/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.ErrorProneEndPosTable;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Implementing a functional interface is unnecessary; prefer to implement the functional interface method directly and use a method reference instead.", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryAnonymousClass
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = tree.getInitializer();
        if (!(expressionTree instanceof NewClassTree)) {
            return Description.NO_MATCH;
        }
        NewClassTree classTree = (NewClassTree)expressionTree;
        if (classTree.getClassBody() == null) {
            return Description.NO_MATCH;
        }
        ImmutableList members = (ImmutableList)classTree.getClassBody().getMembers().stream().filter(x -> {
            MethodTree methodTree;
            return !(x instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)(methodTree = (MethodTree)x)));
        }).collect(ImmutableList.toImmutableList());
        if (members.size() != 1) {
            return Description.NO_MATCH;
        }
        Tree member = (Tree)Iterables.getOnlyElement((Iterable)members);
        if (!(member instanceof MethodTree)) {
            return Description.NO_MATCH;
        }
        MethodTree implementation = (MethodTree)member;
        Symbol.VarSymbol varSym = ASTHelpers.getSymbol((VariableTree)tree);
        if (varSym.getKind() != ElementKind.FIELD || !ASTHelpers.canBeRemoved((Symbol.VarSymbol)varSym) || !varSym.getModifiers().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType((Tree)tree.getType());
        if (type == null || !state.getTypes().isFunctionalInterface(type)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)implementation);
        Symbol descriptorSymbol = state.getTypes().findDescriptorSymbol(type.tsym);
        if (!((Name)methodSymbol.getSimpleName()).contentEquals(descriptorSymbol.getSimpleName())) {
            return Description.NO_MATCH;
        }
        if (!methodSymbol.overrides(descriptorSymbol, ASTHelpers.enclosingClass((Symbol)methodSymbol), state.getTypes(), false)) {
            return Description.NO_MATCH;
        }
        if (tree.getModifiers().getAnnotations().stream().anyMatch(at -> ASTHelpers.getSymbol((Tree)at).getQualifiedName().contentEquals("org.mockito.Spy"))) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        String newName = varSym.isStatic() ? (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)tree.getName().toString()) : tree.getName().toString();
        fixBuilder.merge(SuggestedFixes.renameMethod((MethodTree)implementation, (String)newName, (VisitorState)state));
        SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        fixBuilder.merge(UnnecessaryAnonymousClass.trimToMethodDef(tree, state, implementation));
        return UnnecessaryAnonymousClass.replaceUsesWithMethodReference(newName, varSym, implementation, state).map(mrr -> this.describeMatch(tree, (Fix)fixBuilder.merge(mrr).build())).orElse(Description.NO_MATCH);
    }

    private static SuggestedFix trimToMethodDef(VariableTree varDefinitionTree, VisitorState state, MethodTree implementation) {
        int methodModifiersEndPos = state.getEndPosition((Tree)implementation.getModifiers());
        if (methodModifiersEndPos == -1) {
            methodModifiersEndPos = ASTHelpers.getStartPosition((Tree)implementation);
        }
        int methodDefEndPos = state.getEndPosition((Tree)implementation);
        int varModifiersEndPos = state.getEndPosition((Tree)varDefinitionTree.getModifiers()) + 1;
        int varDefEndPos = state.getEndPosition((Tree)varDefinitionTree);
        return SuggestedFix.builder().replace(varModifiersEndPos, methodModifiersEndPos, "").replace(methodDefEndPos, varDefEndPos, "").build();
    }

    private static Optional<SuggestedFix> replaceUsesWithMethodReference(String newName, Symbol varSym, MethodTree implementation, VisitorState state) {
        BlockTree methodBody = implementation.getBody();
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        ReplaceUsesScanner replaceUsesScanner = new ReplaceUsesScanner(varSym, newName, state);
        replaceUsesScanner.scan(compilationUnit, null);
        return replaceUsesScanner.getFixes().map(fix -> UnnecessaryAnonymousClass.ensureFixesDoNotOverlap(methodBody, compilationUnit, fix, state));
    }

    private static SuggestedFix ensureFixesDoNotOverlap(Tree methodBody, CompilationUnitTree compilationUnit, SuggestedFix fix, VisitorState state) {
        StringBuilder methodBodySource = new StringBuilder(Objects.requireNonNull(state.getSourceForNode(methodBody)));
        Range methodBodyPositionRange = Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)methodBody)), (Comparable)Integer.valueOf(state.getEndPosition(methodBody)));
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (Replacement replacement : fix.getReplacements(ErrorProneEndPosTable.create((CompilationUnitTree)compilationUnit))) {
            if (replacement.range().isConnected(methodBodyPositionRange)) {
                methodBodySource.replace(replacement.startPosition() - (Integer)methodBodyPositionRange.lowerEndpoint(), replacement.endPosition() - (Integer)methodBodyPositionRange.lowerEndpoint(), replacement.replaceWith());
                continue;
            }
            fixBuilder.replace(replacement.startPosition(), replacement.endPosition(), replacement.replaceWith());
        }
        return fixBuilder.replace(methodBody, methodBodySource.toString()).build();
    }

    private static class ReplaceUsesScanner
    extends TreePathScanner<Void, Void> {
        private final Symbol sym;
        private final String newName;
        private final VisitorState state;
        private final SuggestedFix.Builder fix = SuggestedFix.builder();
        private boolean failed = false;

        ReplaceUsesScanner(Symbol sym, String newName, VisitorState state) {
            this.sym = sym;
            this.newName = newName;
            this.state = state;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Void unused) {
            if (Objects.equals(ASTHelpers.getSymbol((Tree)node), this.sym)) {
                this.fix.merge(this.replaceUseWithMethodReference(node, this.state.withPath(this.getCurrentPath())));
            }
            return (Void)super.visitMemberSelect(node, null);
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void unused) {
            if (Objects.equals(ASTHelpers.getSymbol((Tree)node), this.sym)) {
                this.fix.merge(this.replaceUseWithMethodReference(node, this.state.withPath(this.getCurrentPath())));
            }
            return (Void)super.visitIdentifier(node, null);
        }

        private @Nullable SuggestedFix replaceUseWithMethodReference(ExpressionTree node, VisitorState state) {
            MemberSelectTree memberSelectTree;
            Tree parent = state.getPath().getParentPath().getLeaf();
            if (parent instanceof MemberSelectTree && (memberSelectTree = (MemberSelectTree)parent).getExpression().equals(node)) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)parent);
                if (symbol.getKind() != ElementKind.METHOD || !symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    this.failed = true;
                    return null;
                }
                ExpressionTree receiver = node instanceof IdentifierTree ? null : ASTHelpers.getReceiver((ExpressionTree)node);
                return SuggestedFix.replace((int)(receiver != null ? state.getEndPosition((Tree)receiver) : ASTHelpers.getStartPosition((Tree)node)), (int)state.getEndPosition(parent), (String)this.newName);
            }
            Symbol sym = ASTHelpers.getSymbol((Tree)node);
            return SuggestedFix.replace((Tree)node, (String)String.format("%s::%s", ASTHelpers.isStatic((Symbol)sym) ? ASTHelpers.enclosingClass((Symbol)sym).getSimpleName() : "this", this.newName));
        }

        Optional<SuggestedFix> getFixes() {
            return this.failed ? Optional.empty() : Optional.of(this.fix.build());
        }
    }
}

