/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Thread.Builder.name() does not accept placeholders (e.g., %d or %s). threadBuilder.name(String) accepts a constant name and threadBuilder.name(String, int) accepts a constant name _prefix_ and an initial counter value.", severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
public final class ThreadBuilderNameWithPlaceholder
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> THREAD_BUILDER_NAME = Matchers.instanceMethod().onDescendantOf("java.lang.Thread.Builder").named("name");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String nameValue;
        if (THREAD_BUILDER_NAME.matches((Tree)tree, state) && (nameValue = (String)ASTHelpers.constValue((Tree)tree.getArguments().getFirst(), String.class)) != null && (nameValue.contains("%d") || nameValue.contains("%s"))) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

