/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;
import java.util.regex.Pattern;
import javax.inject.Inject;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This setter seems to be invoked with a value from its own getter. Is it redundant?")
public final class SelfSet
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final ConstantExpressions constantExpressions;
    private static final Matcher<ExpressionTree> PROTO_SETTER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").withNameMatching(Pattern.compile("set.*"));
    private static final Matcher<ExpressionTree> PROTO_GETTER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLiteOrBuilder").withNameMatching(Pattern.compile("get.*"));

    @Inject
    SelfSet(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!PROTO_SETTER.matches((Tree)tree, state) || tree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (!PROTO_GETTER.matches((Tree)argument, state)) {
            return Description.NO_MATCH;
        }
        String getterName = ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString().replaceFirst("^set", "get");
        if (!ASTHelpers.getSymbol((Tree)argument).getSimpleName().contentEquals(getterName)) {
            return Description.NO_MATCH;
        }
        ExpressionTree setterReceiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        ExpressionTree getterReceiver = ASTHelpers.getReceiver((ExpressionTree)argument);
        if (setterReceiver == null || getterReceiver == null) {
            return Description.NO_MATCH;
        }
        if (!this.constantExpressions.isSame(setterReceiver, getterReceiver, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

