/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ReplacementVariableFinder;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Variable assigned to itself", severity=BugPattern.SeverityLevel.ERROR)
public class SelfAssignment
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<MethodInvocationTree> NON_NULL_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Objects").named("requireNonNull"), Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.staticMethod().onClass("com.google.common.time.Durations").namedAnyOf(new String[]{"checkNotNegative", "checkPositive"}), Matchers.staticMethod().onClass("com.google.protobuf.util.Durations").namedAnyOf(new String[]{"checkNotNegative", "checkPositive", "checkValid"}), Matchers.staticMethod().onClass("com.google.protobuf.util.Timestamps").named("checkValid")});

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        ExpressionTree expression = SelfAssignment.skipCast(SelfAssignment.stripNullCheck(tree.getExpression(), state));
        if (ASTHelpers.sameVariable((ExpressionTree)tree.getVariable(), (ExpressionTree)expression)) {
            return this.describeForAssignment(tree, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        MemberSelectTree rhs;
        Tree parent;
        block5: {
            block4: {
                ExpressionTree initializer = SelfAssignment.stripNullCheck(tree.getInitializer(), state);
                parent = state.getPath().getParentPath().getLeaf();
                if (initializer == null || !(initializer instanceof MemberSelectTree)) break block4;
                rhs = (MemberSelectTree)initializer;
                if (parent.getKind() == Tree.Kind.CLASS && tree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) break block5;
            }
            return Description.NO_MATCH;
        }
        Symbol rhsClass = ASTHelpers.getSymbol((Tree)rhs.getExpression());
        Symbol lhsClass = ASTHelpers.getSymbol((Tree)parent);
        if (rhsClass != null && lhsClass != null && rhsClass.equals(lhsClass) && rhs.getIdentifier().contentEquals(tree.getName())) {
            return this.describeForVarDecl(tree, state);
        }
        return Description.NO_MATCH;
    }

    private static ExpressionTree skipCast(ExpressionTree expression) {
        return (ExpressionTree)new SimpleTreeVisitor<ExpressionTree, Void>(){

            @Override
            public ExpressionTree visitParenthesized(ParenthesizedTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }

            @Override
            public ExpressionTree visitTypeCast(TypeCastTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }

            @Override
            protected @Nullable ExpressionTree defaultAction(Tree node, Void unused) {
                ExpressionTree expressionTree;
                return node instanceof ExpressionTree ? (expressionTree = (ExpressionTree)node) : null;
            }
        }.visit(expression, null);
    }

    private static ExpressionTree stripNullCheck(ExpressionTree expression, VisitorState state) {
        MethodInvocationTree methodInvocation;
        if (expression != null && expression instanceof MethodInvocationTree && NON_NULL_MATCHER.matches((Tree)(methodInvocation = (MethodInvocationTree)expression), state)) {
            return methodInvocation.getArguments().getFirst();
        }
        return expression;
    }

    public Description describeForVarDecl(VariableTree tree, VisitorState state) {
        Object varDeclStr = state.getSourceForNode((Tree)tree);
        int equalsIndex = ((String)varDeclStr).indexOf(61);
        if (equalsIndex < 0) {
            throw new IllegalStateException("Expected variable declaration to have an initializer: " + state.getSourceForNode((Tree)tree));
        }
        varDeclStr = ((String)varDeclStr).substring(0, equalsIndex - 1) + ";";
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)varDeclStr));
    }

    public Description describeForAssignment(AssignmentTree assignmentTree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        SuggestedFix fix = SuggestedFix.delete((Tree)parent);
        ExpressionTree lhs = assignmentTree.getVariable();
        ExpressionTree rhs = assignmentTree.getExpression();
        if (assignmentTree.getExpression() instanceof MethodInvocationTree) {
            fix = SuggestedFix.replace((Tree)assignmentTree, (String)state.getSourceForNode((Tree)rhs));
            rhs = SelfAssignment.stripNullCheck(rhs, state);
        }
        rhs = SelfAssignment.skipCast(rhs);
        ImmutableList<Fix> exploratoryFieldFixes = ImmutableList.of();
        if (lhs instanceof MemberSelectTree) {
            Preconditions.checkState((rhs instanceof IdentifierTree || rhs instanceof MemberSelectTree ? 1 : 0) != 0);
            Type rhsType = ASTHelpers.getType((Tree)rhs);
            exploratoryFieldFixes = ReplacementVariableFinder.fixesByReplacingExpressionWithMethodParameter(rhs, varDecl -> ASTHelpers.isSameType((Type)rhsType, (Type)varDecl.type, (VisitorState)state), state);
        } else if (rhs instanceof IdentifierTree) {
            Preconditions.checkState((boolean)(lhs instanceof IdentifierTree));
            Type lhsType = ASTHelpers.getType((Tree)lhs);
            exploratoryFieldFixes = ReplacementVariableFinder.fixesByReplacingExpressionWithLocallyDeclaredField(lhs, var -> !Flags.isStatic(var.sym) && (var.sym.flags() & 0x10L) == 0L && ASTHelpers.isSameType((Type)lhsType, (Type)var.type, (VisitorState)state), state);
        }
        if (exploratoryFieldFixes.isEmpty()) {
            return this.describeMatch(assignmentTree, (Fix)fix);
        }
        return this.buildDescription(assignmentTree).addAllFixes((List)exploratoryFieldFixes).build();
    }
}

