/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This overriding method is redundant, and can be removed.", severity=BugPattern.SeverityLevel.WARNING)
public final class RedundantOverride
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        ImmutableSet<Symbol> methodAnnotations;
        Types types;
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        Optional<Symbol.MethodSymbol> maybeSuperMethod = ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)(types = state.getTypes())).filter(t -> !t.owner.isInterface()).findFirst();
        if (maybeSuperMethod.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol superMethod = maybeSuperMethod.get();
        if (tree.getBody() == null || tree.getBody().getStatements().size() != 1) {
            return Description.NO_MATCH;
        }
        StatementTree statement = tree.getBody().getStatements().getFirst();
        MethodInvocationTree expression = RedundantOverride.getSingleInvocation(statement);
        if (expression == null) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree methodInvocationTree = expression;
        if (!ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).equals(superMethod)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        if (!(receiver instanceof IdentifierTree)) {
            return Description.NO_MATCH;
        }
        IdentifierTree identifierTree = (IdentifierTree)receiver;
        if (!identifierTree.getName().contentEquals("super")) {
            return Description.NO_MATCH;
        }
        DocCommentTree docCommentTree = JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
        if (docCommentTree != null) {
            return Description.NO_MATCH;
        }
        if (!methodSymbol.getModifiers().equals(superMethod.getModifiers())) {
            return Description.NO_MATCH;
        }
        if (methodSymbol.getModifiers().contains((Object)Modifier.PROTECTED) && !Objects.equals(ASTHelpers.enclosingPackage((Symbol)superMethod), ASTHelpers.enclosingPackage((Symbol)methodSymbol))) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Symbol> superAnnotations = RedundantOverride.getAnnotations(superMethod);
        if (!Sets.difference((Set)Sets.symmetricDifference(superAnnotations, methodAnnotations = RedundantOverride.getAnnotations(methodSymbol)), (Set)ImmutableSet.of((Object)state.getSymtab().overrideType.tsym)).isEmpty()) {
            return Description.NO_MATCH;
        }
        for (int i = 0; i < tree.getParameters().size(); ++i) {
            if (!(methodInvocationTree.getArguments().get(i) instanceof IdentifierTree)) {
                return Description.NO_MATCH;
            }
            Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol((VariableTree)tree.getParameters().get(i));
            if (!varSymbol.equals(ASTHelpers.getSymbol((Tree)methodInvocationTree.getArguments().get(i)))) {
                return Description.NO_MATCH;
            }
            ImmutableSet<Symbol> paramAnnotations = RedundantOverride.getAnnotations(varSymbol);
            ImmutableSet<Symbol> superParamAnnotations = RedundantOverride.getAnnotations(superMethod.params.get(i));
            if (superParamAnnotations.equals(paramAnnotations)) continue;
            return Description.NO_MATCH;
        }
        if (state.getOffsetTokensForNode((Tree)tree.getBody()).stream().anyMatch(t -> !t.comments().isEmpty())) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.delete((Tree)tree));
    }

    private static @Nullable MethodInvocationTree getSingleInvocation(StatementTree statement) {
        return statement.accept(new SimpleTreeVisitor<MethodInvocationTree, Void>(){

            @Override
            public MethodInvocationTree visitReturn(ReturnTree returnTree, Void unused) {
                return (MethodInvocationTree)this.visit(returnTree.getExpression(), null);
            }

            @Override
            public MethodInvocationTree visitExpressionStatement(ExpressionStatementTree expressionStatement, Void unused) {
                return (MethodInvocationTree)this.visit(expressionStatement.getExpression(), null);
            }

            @Override
            public MethodInvocationTree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                return methodInvocationTree;
            }
        }, null);
    }

    private static ImmutableSet<Symbol> getAnnotations(Symbol symbol) {
        return (ImmutableSet)symbol.getRawAttributes().stream().map(a -> a.type.tsym).collect(ImmutableSet.toImmutableSet());
    }
}

