/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

@BugPattern(altNames={"MutableConstantField", "MutableMethodReturnType"}, summary="This type can be more specific.", severity=BugPattern.SeverityLevel.WARNING)
public final class PreferredInterfaceType
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableList<BetterTypes> BETTER_TYPES = ImmutableList.of((Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"java.lang.Iterable"), "com.google.common.collect.ImmutableSortedSet", "com.google.common.collect.ImmutableSortedMap", "com.google.common.collect.ImmutableSortedMultiset", "com.google.common.collect.ImmutableList", "com.google.common.collect.ImmutableSet", "com.google.common.collect.ImmutableCollection", "java.util.List", "java.util.Set"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"java.util.Map"), "com.google.common.collect.ImmutableMap"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.collect.Table"), "com.google.common.collect.ImmutableTable"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.collect.RangeSet"), "com.google.common.collect.ImmutableRangeSet"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.collect.RangeMap"), "com.google.common.collect.ImmutableRangeMap"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.collect.Multimap"), "com.google.common.collect.ImmutableListMultimap", "com.google.common.collect.ImmutableSetMultimap", "com.google.common.collect.ImmutableMultimap", "com.google.common.collect.ListMultimap", "com.google.common.collect.SetMultimap"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"java.lang.CharSequence"), "java.lang.String"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.graph.Graph"), "com.google.common.graph.ImmutableGraph"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.graph.ValueGraph"), "com.google.common.graph.ImmutableValueGraph"), (Object)BetterTypes.of(TypePredicates.isDescendantOf((String)"com.google.common.graph.Network"), "com.google.common.graph.ImmutableNetwork"));
    private static final Matcher<Tree> INTERESTING_TYPE = Matchers.anyOf((Iterable)((Iterable)BETTER_TYPES.stream().map(bt -> Matchers.typePredicateMatcher((TypePredicate)bt.predicate())).collect(ImmutableList.toImmutableList())));
    public static final Matcher<Tree> SHOULD_IGNORE = Matchers.anyOf((Matcher[])new Matcher[]{InjectMatchers.hasProvidesAnnotation(), Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.inject.testing.fieldbinder.Bind")}))});
    private final WellKnownKeep wellKnownKeep;
    private static final String IMMUTABLE_MESSAGE = " type should use the immutable type (such as ImmutableList) instead of the general collection interface type (such as List).";
    private static final String NON_IMMUTABLE_MESSAGE = " type can use a more specific type to convey more information to callers.";
    private static final String OVERRIDE_NOTE = " Note that it is possible to return a more specific type even when overriding a method.";

    @Inject
    PreferredInterfaceType(WellKnownKeep wellKnownKeep) {
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableMap<Symbol, Tree> fixableTypes = this.getFixableTypes(state);
        ArrayListMultimap symbolsToType = ArrayListMultimap.create();
        new TreePathScanner<Void, Void>(this, (ListMultimap)symbolsToType, fixableTypes){
            private final Deque<Symbol> currentMethod = new LinkedList<Symbol>();
            final /* synthetic */ ListMultimap val$symbolsToType;
            final /* synthetic */ ImmutableMap val$fixableTypes;
            {
                this.val$symbolsToType = listMultimap;
                this.val$fixableTypes = immutableMap;
            }

            @Override
            public Void visitMethod(MethodTree node, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)node);
                this.currentMethod.addLast(methodSymbol);
                super.visitMethod(node, null);
                this.currentMethod.removeLast();
                return null;
            }

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                if (node.getInitializer() != null) {
                    this.val$symbolsToType.put((Object)ASTHelpers.getSymbol((VariableTree)node), (Object)ASTHelpers.getType((Tree)node.getInitializer()));
                }
                return (Void)super.visitVariable(node, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree node, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)node.getVariable());
                if (this.val$fixableTypes.containsKey((Object)symbol)) {
                    this.val$symbolsToType.put((Object)symbol, (Object)ASTHelpers.getType((Tree)node.getExpression()));
                }
                return (Void)super.visitAssignment(node, null);
            }

            @Override
            public Void visitReturn(ReturnTree node, Void unused) {
                Symbol method = this.currentMethod.peekLast();
                if (method != null) {
                    this.val$symbolsToType.put((Object)method, (Object)ASTHelpers.getType((Tree)node.getExpression()));
                }
                return (Void)super.visitReturn(node, null);
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                this.currentMethod.addLast(null);
                super.visitLambdaExpression(node, null);
                this.currentMethod.removeLast();
                return null;
            }
        }.scan(state.getPath(), (Void)null);
        this.reportFixes((Map<Symbol, Tree>)fixableTypes, (ListMultimap<Symbol, Type>)symbolsToType, state);
        return Description.NO_MATCH;
    }

    private ImmutableMap<Symbol, Tree> getFixableTypes(VisitorState state) {
        final ImmutableMap.Builder fixableTypes = ImmutableMap.builder();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ PreferredInterfaceType this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
                if (this.variableIsFixable(tree, symbol)) {
                    fixableTypes.put((Object)symbol, (Object)tree.getType());
                }
                return (Void)super.visitVariable(tree, null);
            }

            private boolean variableIsFixable(VariableTree tree, Symbol.VarSymbol symbol) {
                if (symbol == null) {
                    return false;
                }
                if (symbol.getKind() == ElementKind.PARAMETER) {
                    return false;
                }
                if (this.this$0.wellKnownKeep.shouldKeep(tree)) {
                    return false;
                }
                if (SHOULD_IGNORE.matches((Tree)tree, this.state)) {
                    return false;
                }
                if (symbol.getKind() == ElementKind.FIELD && !ASTHelpers.isConsideredFinal((Symbol)symbol) && !ASTHelpers.canBeRemoved((Symbol.VarSymbol)symbol)) {
                    return false;
                }
                return Matchers.variableType(INTERESTING_TYPE).matches((Tree)tree, this.state);
            }

            public Void visitMethod(MethodTree node, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)node);
                if (Matchers.methodReturns(INTERESTING_TYPE).matches((Tree)node, this.state) && !ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)methodSymbol) && !SHOULD_IGNORE.matches((Tree)node, this.state)) {
                    fixableTypes.put((Object)methodSymbol, (Object)node.getReturnType());
                }
                return (Void)super.visitMethod(node, null);
            }
        }.scan(state.getPath(), null);
        return fixableTypes.buildOrThrow();
    }

    private void reportFixes(Map<Symbol, Tree> fixableTypes, ListMultimap<Symbol, Type> symbolsToType, VisitorState state) {
        Types types = state.getTypes();
        for (Map.Entry entry : Multimaps.asMap(symbolsToType).entrySet()) {
            Types types2;
            Symbol symbol = (Symbol)entry.getKey();
            List assignedTypes = (List)entry.getValue();
            Tree tree = fixableTypes.get(symbol);
            if (tree == null) continue;
            Stream<Type> stream = assignedTypes.stream().filter(type -> !type.getKind().equals((Object)TypeKind.NULL)).map(type -> ASTHelpers.getUpperBound((Type)type, (Types)types));
            Objects.requireNonNull(types);
            stream.reduce((xva$0, xva$1) -> types2.lub((Type)xva$0, (Type)xva$1)).flatMap(type -> PreferredInterfaceType.toGoodReplacement(type, state)).filter(replacement -> !ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)replacement, (VisitorState)state)).filter(replacement -> ASTHelpers.isSubtype((Type)replacement, (Type)ASTHelpers.getType((Tree)tree), (VisitorState)state)).ifPresent(type -> {
                SuggestedFix.Builder builder = SuggestedFix.builder();
                SuggestedFix fix = builder.replace(ASTHelpers.getErasedTypeTree((Tree)tree), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (Symbol)type.asElement())).build();
                state.reportMatch(this.buildDescription(tree).setMessage(PreferredInterfaceType.getMessage(symbol, type, state)).addFix((Fix)fix).build());
            });
        }
    }

    private static String getMessage(Symbol symbol, Type newType, VisitorState state) {
        String messageBase;
        String string = messageBase = !PreferredInterfaceType.isImmutable(PreferredInterfaceType.targetType(symbol)) && PreferredInterfaceType.isImmutable(newType) ? IMMUTABLE_MESSAGE : NON_IMMUTABLE_MESSAGE;
        if (symbol instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            if (!ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes()).isEmpty()) {
                return "Method return" + messageBase + OVERRIDE_NOTE;
            }
            return "Method return" + messageBase;
        }
        return "Variable" + messageBase;
    }

    private static Type targetType(Symbol symbol) {
        Type type;
        if (symbol instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            type = methodSymbol.getReturnType();
        } else {
            type = symbol.type;
        }
        return type;
    }

    private static boolean isImmutable(Type type) {
        return type.tsym.getQualifiedName().toString().startsWith("com.google.common.collect.Immutable");
    }

    private static Optional<Type> toGoodReplacement(Type type, VisitorState state) {
        return BETTER_TYPES.stream().filter(bt -> bt.predicate().apply(type, state)).map(BetterTypes::betterTypes).findFirst().flatMap(betterTypes -> betterTypes.stream().map(typeName -> (Type)Suppliers.typeFromString((String)typeName).get(state)).filter(sensibleType -> sensibleType != null && ASTHelpers.isSubtype((Type)type, (Type)sensibleType, (VisitorState)state)).findFirst());
    }

    private record BetterTypes(TypePredicate predicate, ImmutableSet<String> betterTypes) {
        private static BetterTypes of(TypePredicate predicate, String ... betterTypes) {
            return new BetterTypes(predicate, (ImmutableSet<String>)ImmutableSet.copyOf((Object[])betterTypes));
        }
    }
}

