/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="This call passes a null *array*, so it always produces NullPointerException. To pass a null *element*, cast to the element type.", severity=BugPattern.SeverityLevel.ERROR)
public final class NullNeedsCastForVarargs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableList<Supplier<Type>> JUST_OBJECT_TYPE_ARRAY = ImmutableList.of((Object)Suppliers.OBJECT_TYPE_ARRAY);
    private static final Matcher<ExpressionTree> METHOD_WITH_SOLE_PARAMETER_OBJECT_VARARGS = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("containsExactly").withParametersOfType(JUST_OBJECT_TYPE_ARRAY);
    private static final Matcher<ExpressionTree> METHOD_WITH_SECOND_PARAMETER_OBJECT_VARARGS = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.reflect.Invokable").named("invoke").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.OBJECT_TYPE, (Object)Suppliers.OBJECT_TYPE_ARRAY));
    private static final Matcher<ExpressionTree> METHOD_WITH_THIRD_PARAMETER_OBJECT_VARARGS = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"containsAnyOf", "containsAtLeast", "containsNoneOf", "isAnyOf", "isNoneOf"}).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.OBJECT_TYPE, (Object)Suppliers.OBJECT_TYPE, (Object)Suppliers.OBJECT_TYPE_ARRAY));
    private static final Matcher<ExpressionTree> METHOD_WITH_SOLE_PARAMETER_GENERIC_VARARGS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.AndroidAccessToCompactDataStructures").namedAnyOf(new String[]{"newCompactHashSet", "newCompactLinkedHashSet"}).withParametersOfType(JUST_OBJECT_TYPE_ARRAY), MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.collect.CompactHashSet", "com.google.common.collect.CompactLinkedHashSet"}).named("create").withParametersOfType(JUST_OBJECT_TYPE_ARRAY), MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.collect.Iterables", "com.google.common.collect.Iterators"}).namedAnyOf(new String[]{"cycle", "forArray"}).withParametersOfType(JUST_OBJECT_TYPE_ARRAY), MethodMatchers.staticMethod().onClass("com.google.common.collect.Lists").namedAnyOf(new String[]{"newArrayList", "newLinkedList"}).withParametersOfType(JUST_OBJECT_TYPE_ARRAY), MethodMatchers.staticMethod().onClass("com.google.common.collect.Sets").namedAnyOf(new String[]{"newHashSet", "newLinkedHashSet"}).withParametersOfType(JUST_OBJECT_TYPE_ARRAY), MethodMatchers.staticMethod().onClass("java.util.Arrays").named("asList"), MethodMatchers.staticMethod().onClass("java.util.stream.Stream").named("of").withParametersOfType(JUST_OBJECT_TYPE_ARRAY)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (METHOD_WITH_SOLE_PARAMETER_OBJECT_VARARGS.matches((Tree)tree, state)) {
            return this.matchObjectVarargs(arguments, 0);
        }
        if (METHOD_WITH_SECOND_PARAMETER_OBJECT_VARARGS.matches((Tree)tree, state)) {
            return this.matchObjectVarargs(arguments, 1);
        }
        if (METHOD_WITH_THIRD_PARAMETER_OBJECT_VARARGS.matches((Tree)tree, state)) {
            return this.matchObjectVarargs(arguments, 2);
        }
        if (METHOD_WITH_SOLE_PARAMETER_GENERIC_VARARGS.matches((Tree)tree, state)) {
            return this.matchGenericVarargs(state, arguments);
        }
        return Description.NO_MATCH;
    }

    private Description matchObjectVarargs(List<? extends ExpressionTree> arguments, int varargsStart) {
        if (arguments.size() != varargsStart + 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = arguments.getLast();
        if (arg.getKind() == Tree.Kind.NULL_LITERAL || NullNeedsCastForVarargs.isCastOfNullToArray(arg)) {
            return this.describeMatch(arg, (Fix)SuggestedFix.replace((Tree)arg, (String)"(Object) null"));
        }
        return Description.NO_MATCH;
    }

    private Description matchGenericVarargs(VisitorState state, List<? extends ExpressionTree> arguments) {
        if (arguments.size() != 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = arguments.getLast();
        if (arg.getKind() == Tree.Kind.NULL_LITERAL || NullNeedsCastForVarargs.isCastOfNullToArrayOfTargetTypeElementType(arg, state)) {
            Type elementType = NullNeedsCastForVarargs.targetTypElementType(state);
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String prettyName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)elementType);
            fix.replace((Tree)arg, "(%s) null".formatted(prettyName));
            return this.describeMatch(arg, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    private static boolean isCastOfNullToArray(ExpressionTree arg) {
        if (!(arg instanceof TypeCastTree)) {
            return false;
        }
        TypeCastTree castTree = (TypeCastTree)arg;
        if (castTree.getExpression().getKind() != Tree.Kind.NULL_LITERAL) {
            return false;
        }
        Type castType = ASTHelpers.getType((Tree)castTree.getType());
        return castType.getKind() == TypeKind.ARRAY;
    }

    private static boolean isCastOfNullToArrayOfTargetTypeElementType(ExpressionTree arg, VisitorState state) {
        if (!NullNeedsCastForVarargs.isCastOfNullToArray(arg)) {
            return false;
        }
        TypeCastTree castTree = (TypeCastTree)arg;
        Type.ArrayType castType = (Type.ArrayType)ASTHelpers.getType((Tree)castTree.getType());
        Type elementType = NullNeedsCastForVarargs.targetTypElementType(state);
        return state.getTypes().isSubtype(castType.getComponentType(), elementType);
    }

    private static Type targetTypElementType(VisitorState state) {
        TargetType targetType = TargetType.targetType((VisitorState)state);
        return targetType != null && !targetType.type().getTypeArguments().isEmpty() ? (Type)targetType.type().getTypeArguments().getFirst() : state.getSymtab().objectType;
    }
}

