/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Iterating over `Multimap.keys()` does not collapse duplicates. Did you mean `keySet()`?", severity=BugPattern.SeverityLevel.WARNING)
public final class MultimapKeys
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> KEYS = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.collect.Multimap").named("keys");
    private static final Matcher<ExpressionTree> FOR_EACH = MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("forEach");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return KEYS.matches((Tree)tree, state) && MultimapKeys.isBeingIteratedOver(state) ? this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"keySet", (VisitorState)state)) : Description.NO_MATCH;
    }

    private static boolean isBeingIteratedOver(VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof EnhancedForLoopTree) {
            return true;
        }
        if (parent instanceof MemberSelectTree) {
            MethodInvocationTree methodInvocationTree;
            Tree grandparent = state.getPath().getParentPath().getParentPath().getLeaf();
            return grandparent instanceof MethodInvocationTree && FOR_EACH.matches((Tree)(methodInvocationTree = (MethodInvocationTree)grandparent), state);
        }
        return false;
    }
}

