/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="The Refaster template contains a method without any Refaster annotations", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public final class MissingRefasterAnnotation
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final MultiMatcher<Tree, AnnotationTree> HAS_REFASTER_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.errorprone.refaster.annotation.Placeholder"), Matchers.isType((String)"com.google.errorprone.refaster.annotation.BeforeTemplate"), Matchers.isType((String)"com.google.errorprone.refaster.annotation.AfterTemplate")}));

    public Description matchClass(ClassTree tree, VisitorState state) {
        long methodTypeCount = tree.getMembers().stream().filter(member -> member instanceof MethodTree).map(MethodTree.class::cast).filter(method -> !ASTHelpers.isGeneratedConstructor((MethodTree)method)).map(method -> HAS_REFASTER_ANNOTATION.matches((Tree)method, state)).distinct().count();
        return methodTypeCount < 2L ? Description.NO_MATCH : this.describeMatch(tree);
    }
}

