/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.TypeTag;

@BugPattern(summary="Conversion from int to float may lose precision; use an explicit cast to float if this was intentional", severity=BugPattern.SeverityLevel.WARNING)
public class IntFloatConversion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.lang.Math").named("scalb").withParameters("float", new String[]{"int"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree arg = tree.getArguments().getFirst();
        if (!ASTHelpers.getType((Tree)arg).hasTag(TypeTag.INT)) {
            return Description.NO_MATCH;
        }
        TargetType targetType = TargetType.targetType((VisitorState)state);
        if (targetType == null || !targetType.type().hasTag(TypeTag.DOUBLE)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(arg, (Fix)SuggestedFix.prefixWith((Tree)arg, (String)"(double) "));
    }
}

