/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Prefer collection factory methods or builders to the double-brace initialization pattern.", severity=BugPattern.SeverityLevel.ERROR)
public class DoubleBraceInitialization
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        ClassTree body = tree.getClassBody();
        if (body == null) {
            return Description.NO_MATCH;
        }
        ImmutableList members = (ImmutableList)body.getMembers().stream().filter(m -> {
            MethodTree methodTree;
            return !(m instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)(methodTree = (MethodTree)m)));
        }).collect(ImmutableList.toImmutableList());
        if (members.size() != 1) {
            return Description.NO_MATCH;
        }
        Tree member = (Tree)Iterables.getOnlyElement((Iterable)members);
        if (!(member instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)member;
        Optional<CollectionTypes> collectionType = Arrays.stream(CollectionTypes.values()).filter(type -> type.constructorMatcher.matches((Tree)tree, state)).findFirst();
        if (collectionType.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        collectionType.get().maybeFix(tree, state, block).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }

    static enum CollectionTypes {
        MAP("Map", "put", "ImmutableMap"),
        SET("Set", "add", "ImmutableSet"),
        LIST("List", "add", "ImmutableList"),
        COLLECTION("Collection", "add", "ImmutableList");

        final Matcher<ExpressionTree> constructorMatcher;
        final Matcher<StatementTree> mutateMatcher;
        final Matcher<Tree> unmodifiableMatcher;
        final String factoryMethod;
        final String factoryImport;
        final String immutableType;
        final String immutableImport;

        private CollectionTypes(String type, String mutator, String factory) {
            this.immutableType = "Immutable" + type;
            this.immutableImport = "com.google.common.collect.Immutable" + type;
            this.factoryMethod = factory + ".of";
            this.factoryImport = "com.google.common.collect." + factory;
            this.constructorMatcher = MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf((String)("java.util." + type)));
            this.mutateMatcher = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onDescendantOf("java.util." + type).named(mutator));
            this.unmodifiableMatcher = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.staticMethod().onClass("java.util.Collections").named("unmodifiable" + type));
        }

        /*
         * WARNING - void declaration
         */
        Optional<Fix> maybeFix(NewClassTree tree, VisitorState state, BlockTree block) {
            void var6_8;
            Object replacement;
            ArrayList<List<? extends ExpressionTree>> arguments = new ArrayList<List<? extends ExpressionTree>>();
            for (StatementTree statementTree : block.getStatements()) {
                if (!this.mutateMatcher.matches((Tree)statementTree, state)) {
                    return Optional.empty();
                }
                arguments.add(((MethodInvocationTree)((ExpressionStatementTree)statementTree).getExpression()).getArguments());
            }
            if (arguments.stream().flatMap(Collection::stream).anyMatch(a -> a.getKind() == Tree.Kind.NULL_LITERAL)) {
                return Optional.empty();
            }
            ImmutableList args = (ImmutableList)arguments.stream().map(arg -> arg.stream().map(ASTHelpers::stripParentheses).map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ", "\n", ""))).collect(ImmutableList.toImmutableList());
            Object var6_7 = null;
            boolean constant = false;
            Tree typeTree = null;
            ExpressionTree toReplace = null;
            for (TreePath path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                Tree enclosing = path.getLeaf();
                if (this.unmodifiableMatcher.matches(enclosing, state)) {
                    Tree tree2 = enclosing;
                    continue;
                }
                if (enclosing instanceof ParenthesizedTree) continue;
                if (enclosing instanceof VariableTree) {
                    VariableTree enclosingVariable = (VariableTree)enclosing;
                    toReplace = enclosingVariable.getInitializer();
                    typeTree = enclosingVariable.getType();
                    Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)enclosingVariable);
                    boolean bl = constant = symbol.isStatic() && symbol.getModifiers().contains((Object)Modifier.FINAL) && symbol.getKind() == ElementKind.FIELD;
                }
                if (!(enclosing instanceof ReturnTree)) break;
                ReturnTree returnTree = (ReturnTree)enclosing;
                toReplace = returnTree.getExpression();
                MethodTree enclosingMethod = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)path, MethodTree.class);
                typeTree = enclosingMethod == null ? null : enclosingMethod.getReturnType();
                break;
            }
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (this.immutableType.equals("ImmutableMap") && args.size() > 5) {
                String string;
                ExpressionTree expressionTree = tree.getIdentifier();
                if (expressionTree instanceof ParameterizedTypeTree) {
                    ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)((Object)expressionTree);
                    string = parameterizedTypeTree.getTypeArguments().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ", "<", ">"));
                } else {
                    string = "";
                }
                String typeArguments = string;
                replacement = "ImmutableMap." + typeArguments + "builder()" + args.stream().map(a -> ".put(" + a + ")").collect(Collectors.joining("")) + ".buildOrThrow()";
            } else {
                replacement = args.stream().collect(Collectors.joining(", ", this.factoryMethod + "(", ")"));
            }
            fix.addImport(this.factoryImport);
            fix.addImport(this.immutableImport);
            if (var6_8 != null || constant) {
                if (typeTree instanceof ParameterizedTypeTree) {
                    ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)typeTree;
                    typeTree = parameterizedTypeTree.getType();
                }
                if (typeTree != null) {
                    fix.replace(typeTree, this.immutableType);
                }
                fix.replace((Tree)(var6_8 == null ? toReplace : var6_8), (String)replacement);
            } else {
                fix.replace(state.getEndPosition((Tree)tree.getIdentifier()), state.getEndPosition((Tree)tree), "(" + (String)replacement + ")");
            }
            return Optional.of(fix.build());
        }
    }
}

