/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@BugPattern(summary="Method expects distinct arguments at some/all positions", severity=BugPattern.SeverityLevel.WARNING)
public final class DistinctVarargsChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IMMUTABLE_SET_VARARGS_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.util.Set").named("of"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSet").named("of"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedSet").named("of")});
    private static final Matcher<ExpressionTree> ALL_DISTINCT_ARG_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.util.concurrent.Futures").namedAnyOf(new String[]{"whenAllSucceed", "whenAllComplete"}).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.typeFromString((String)"com.google.common.util.concurrent.ListenableFuture")))), MethodMatchers.staticMethod().onClass("com.google.common.collect.Ordering").named("explicit").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.OBJECT_TYPE, (Object)Suppliers.OBJECT_TYPE_ARRAY))});
    private static final Matcher<ExpressionTree> EVEN_PARITY_DISTINCT_ARG_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableSortedMap").named("of"), MethodMatchers.staticMethod().onClass("java.util.Map").named("of")});
    private static final Matcher<ExpressionTree> EVEN_AND_ODD_PARITY_DISTINCT_ARG_MATCHER = MethodMatchers.staticMethod().onClass("com.google.common.collect.ImmutableBiMap").named("of");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IMMUTABLE_SET_VARARGS_MATCHER.matches((Tree)tree, state)) {
            return this.checkDistinctArgumentsWithFix(tree, state);
        }
        if (ALL_DISTINCT_ARG_MATCHER.matches((Tree)tree, state)) {
            return this.checkDistinctArguments(state, tree.getArguments());
        }
        if (EVEN_PARITY_DISTINCT_ARG_MATCHER.matches((Tree)tree, state)) {
            ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
            for (int index = 0; index < tree.getArguments().size(); index += 2) {
                arguments.add(tree.getArguments().get(index));
            }
            return this.checkDistinctArguments(state, arguments);
        }
        if (EVEN_AND_ODD_PARITY_DISTINCT_ARG_MATCHER.matches((Tree)tree, state)) {
            ArrayList<ExpressionTree> evenParityArguments = new ArrayList<ExpressionTree>();
            ArrayList<ExpressionTree> oddParityArguments = new ArrayList<ExpressionTree>();
            for (int index = 0; index < tree.getArguments().size(); ++index) {
                if (index % 2 == 0) {
                    evenParityArguments.add(tree.getArguments().get(index));
                    continue;
                }
                oddParityArguments.add(tree.getArguments().get(index));
            }
            return this.checkDistinctArguments(state, evenParityArguments, oddParityArguments);
        }
        return Description.NO_MATCH;
    }

    private static ImmutableListMultimap<String, Integer> argumentsByString(VisitorState state, List<? extends ExpressionTree> arguments) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (int i = 0; i < arguments.size(); ++i) {
            result.put((Object)state.getSourceForNode((Tree)arguments.get(i)), (Object)i);
        }
        return result.build();
    }

    private Description checkDistinctArgumentsWithFix(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
        List<? extends ExpressionTree> arguments = tree.getArguments();
        ImmutableListMultimap<String, Integer> argumentsByString = DistinctVarargsChecker.argumentsByString(state, arguments);
        for (Map.Entry entry : argumentsByString.asMap().entrySet()) {
            ((Collection)entry.getValue()).stream().skip(1L).forEachOrdered(index -> suggestedFix.merge(SuggestedFix.replace((int)state.getEndPosition((Tree)arguments.get(index - 1)), (int)state.getEndPosition((Tree)arguments.get((int)index)), (String)"")));
        }
        if (suggestedFix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)suggestedFix.build());
    }

    private Description checkDistinctArguments(VisitorState state, List<? extends ExpressionTree> ... argumentsList) {
        for (List<? extends ExpressionTree> arguments : argumentsList) {
            ImmutableListMultimap<String, Integer> argumentsByString = DistinctVarargsChecker.argumentsByString(state, arguments);
            for (Map.Entry entry : argumentsByString.asMap().entrySet()) {
                ((Collection)entry.getValue()).stream().skip(1L).forEachOrdered(index -> state.reportMatch(this.describeMatch((Tree)arguments.get((int)index))));
            }
        }
        return Description.NO_MATCH;
    }
}

