/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.parser.Tokens;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Annotations should be positioned after Javadocs, but before modifiers.", severity=BugPattern.SeverityLevel.WARNING, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s4.8.5-annotations")
public final class AnnotationPosition
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableMap<String, Tokens.TokenKind> TOKEN_KIND_BY_NAME = (ImmutableMap)EnumSet.allOf(Tokens.TokenKind.class).stream().collect(ImmutableMap.toImmutableMap(tk -> tk.name(), tk -> tk));
    private static final ImmutableSet<Tokens.TokenKind> MODIFIERS = (ImmutableSet)Streams.concat((Stream[])new Stream[]{EnumSet.allOf(Modifier.class).stream().map(m -> (Tokens.TokenKind)TOKEN_KIND_BY_NAME.get((Object)m.name())).filter(Objects::nonNull), Stream.of(Tokens.TokenKind.LT, Tokens.TokenKind.GT, Tokens.TokenKind.GTGT)}).collect(Sets.toImmutableEnumSet());

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.handle(tree, tree.getSimpleName(), tree.getModifiers(), state);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.handle(tree, tree.getName(), tree.getModifiers(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.handle(tree, tree.getName(), tree.getModifiers(), state);
    }

    private Description handle(Tree tree, Name name, ModifiersTree modifiers, VisitorState state) {
        int lastModifierPos;
        ImmutableList modifierTokens;
        int firstModifierPos;
        List<? extends AnnotationTree> annotations = modifiers.getAnnotations();
        if (annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        int treePos = ASTHelpers.getStartPosition((Tree)tree);
        ImmutableList<ErrorProneToken> tokens = AnnotationPosition.annotationTokens(tree, state, treePos);
        ErrorProneComment danglingJavadoc = AnnotationPosition.findOrphanedJavadoc(name, tokens);
        Description description = this.checkAnnotations(tree, annotations, danglingJavadoc, firstModifierPos = (modifierTokens = (ImmutableList)tokens.stream().filter(t -> AnnotationPosition.isModifier(t)).collect(ImmutableList.toImmutableList())).stream().findFirst().map(x -> x.pos()).orElse(Integer.MAX_VALUE).intValue(), lastModifierPos = Streams.findLast((Stream)modifierTokens.stream()).map(x -> x.endPos()).orElse(0).intValue(), state);
        if (!description.equals(Description.NO_MATCH)) {
            return description;
        }
        if (danglingJavadoc == null) {
            return Description.NO_MATCH;
        }
        if (JavacTrees.instance(state.context).getDocCommentTree(state.getPath()) != null) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String javadoc = AnnotationPosition.removeJavadoc(state, danglingJavadoc, builder);
        String message = "Javadocs should appear before any modifiers or annotations.";
        return this.buildDescription(tree).setMessage(message).addFix((Fix)builder.prefixWith(tree, javadoc).build()).build();
    }

    private static ImmutableList<ErrorProneToken> annotationTokens(Tree tree, VisitorState state, int annotationEnd) {
        int endPos;
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodTree.class, VariableTree.class, ClassTree.class}, (Object)tree3, n)) {
            case 0: {
                MethodTree methodTree = (MethodTree)tree3;
                if (methodTree.getReturnType() != null) {
                    endPos = ASTHelpers.getStartPosition((Tree)methodTree.getReturnType());
                    break;
                }
                if (!methodTree.getParameters().isEmpty()) {
                    endPos = ASTHelpers.getStartPosition((Tree)methodTree.getParameters().getFirst());
                    if (endPos >= annotationEnd) break;
                    endPos = state.getEndPosition((Tree)methodTree);
                    break;
                }
                if (methodTree.getBody() != null && !methodTree.getBody().getStatements().isEmpty()) {
                    endPos = ASTHelpers.getStartPosition((Tree)methodTree.getBody().getStatements().getFirst());
                    break;
                }
                endPos = state.getEndPosition((Tree)methodTree);
                break;
            }
            case 1: {
                VariableTree variableTree = (VariableTree)tree3;
                endPos = ASTHelpers.getStartPosition((Tree)variableTree.getType());
                if (endPos != -1) break;
                endPos = state.getEndPosition((Tree)variableTree.getModifiers());
                break;
            }
            case 2: {
                ClassTree classTree = (ClassTree)tree3;
                endPos = classTree.getMembers().isEmpty() ? state.getEndPosition((Tree)classTree) : ASTHelpers.getStartPosition((Tree)classTree.getMembers().getFirst());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return state.getOffsetTokens(annotationEnd, endPos);
    }

    private Description checkAnnotations(Tree tree, List<? extends AnnotationTree> annotations, ErrorProneComment danglingJavadoc, int firstModifierPos, int lastModifierPos, VisitorState state) {
        String isAre;
        String flattened;
        ImmutableList<String> names;
        String javadoc;
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        ImmutableList shouldBeBefore = (ImmutableList)annotations.stream().filter(a -> {
            Position position = AnnotationPosition.annotationPosition(tree, ASTHelpers.getAnnotationType((AnnotationTree)a, (Symbol)symbol, (VisitorState)state));
            return position == Position.BEFORE || position == Position.EITHER && ASTHelpers.getStartPosition((Tree)a) < firstModifierPos;
        }).collect(ImmutableList.toImmutableList());
        ImmutableList shouldBeAfter = (ImmutableList)annotations.stream().filter(a -> {
            Position position = AnnotationPosition.annotationPosition(tree, ASTHelpers.getAnnotationType((AnnotationTree)a, (Symbol)symbol, (VisitorState)state));
            return position == Position.AFTER || position == Position.EITHER && ASTHelpers.getStartPosition((Tree)a) > firstModifierPos;
        }).collect(ImmutableList.toImmutableList());
        int lastNonTypeAnnotationOrModifierPosition = (Integer)Streams.concat((Stream[])new Stream[]{Stream.of(Integer.valueOf(lastModifierPos)), shouldBeBefore.stream().map(ASTHelpers::getStartPosition)}).max(Comparator.naturalOrder()).get();
        int firstTypeAnnotationOrModifierPosition = Stream.concat(Stream.of(Integer.valueOf(firstModifierPos)), shouldBeAfter.stream().map(ASTHelpers::getStartPosition)).min(Comparator.naturalOrder()).get();
        ImmutableList moveBefore = (ImmutableList)shouldBeBefore.stream().filter(a -> ASTHelpers.getStartPosition((Tree)a) > firstTypeAnnotationOrModifierPosition).collect(ImmutableList.toImmutableList());
        ImmutableList moveAfter = (ImmutableList)shouldBeAfter.stream().filter(a -> ASTHelpers.getStartPosition((Tree)a) < lastNonTypeAnnotationOrModifierPosition).collect(ImmutableList.toImmutableList());
        if (moveBefore.isEmpty() && moveAfter.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (AnnotationTree annotation : Iterables.concat((Iterable)moveBefore, (Iterable)moveAfter)) {
            fix.delete((Tree)annotation);
        }
        String string = javadoc = danglingJavadoc == null ? "" : AnnotationPosition.removeJavadoc(state, danglingJavadoc, fix);
        if (lastModifierPos == 0) {
            fix.replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)tree), String.format("%s%s ", javadoc, AnnotationPosition.joinSource(state, Iterables.concat((Iterable)moveBefore, (Iterable)moveAfter))));
        } else {
            fix.replace(firstModifierPos, firstModifierPos, String.format("%s%s ", javadoc, AnnotationPosition.joinSource(state, (Iterable<AnnotationTree>)moveBefore))).replace(lastModifierPos, lastModifierPos, String.format(" %s ", AnnotationPosition.joinSource(state, (Iterable<AnnotationTree>)moveAfter)));
        }
        Stream.Builder<String> messages = Stream.builder();
        if (!moveBefore.isEmpty()) {
            names = AnnotationPosition.annotationNames((List<AnnotationTree>)moveBefore);
            flattened = String.join((CharSequence)", ", names);
            isAre = names.size() > 1 ? "are not TYPE_USE annotations" : "is not a TYPE_USE annotation";
            messages.add(String.format("%s %s, so should appear before any modifiers and after Javadocs.", flattened, isAre));
        }
        if (!moveAfter.isEmpty()) {
            names = AnnotationPosition.annotationNames((List<AnnotationTree>)moveAfter);
            flattened = String.join((CharSequence)", ", names);
            isAre = names.size() > 1 ? "are TYPE_USE annotations" : "is a TYPE_USE annotation";
            messages.add(String.format("%s %s, so should appear after modifiers and directly before the type.", flattened, isAre));
        }
        return this.buildDescription(tree).setMessage(messages.build().collect(Collectors.joining(" "))).addFix((Fix)fix.build()).build();
    }

    private static Position annotationPosition(Tree tree, TypeAnnotations.AnnotationType annotationType) {
        if (tree instanceof ClassTree || annotationType == null) {
            return Position.BEFORE;
        }
        return switch (annotationType) {
            default -> throw new MatchException(null, null);
            case TypeAnnotations.AnnotationType.DECLARATION -> Position.BEFORE;
            case TypeAnnotations.AnnotationType.TYPE -> Position.AFTER;
            case TypeAnnotations.AnnotationType.NONE, TypeAnnotations.AnnotationType.BOTH -> Position.EITHER;
        };
    }

    private static ImmutableList<String> annotationNames(List<AnnotationTree> annotations) {
        return (ImmutableList)annotations.stream().map(ASTHelpers::getSymbol).filter(Objects::nonNull).map(Symbol::getSimpleName).map(a -> "@" + String.valueOf(a)).collect(ImmutableList.toImmutableList());
    }

    private static String joinSource(VisitorState state, Iterable<AnnotationTree> moveBefore) {
        return Streams.stream(moveBefore).map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(" "));
    }

    private static String removeJavadoc(VisitorState state, ErrorProneComment danglingJavadoc, SuggestedFix.Builder builder) {
        int javadocStart = danglingJavadoc.getSourcePos(0);
        int javadocEnd = javadocStart + danglingJavadoc.getText().length();
        if (state.getSourceCode().charAt(javadocEnd) == '\n') {
            ++javadocEnd;
        }
        builder.replace(javadocStart, javadocEnd, "");
        return danglingJavadoc.getText();
    }

    private static @Nullable ErrorProneComment findOrphanedJavadoc(Name name, List<ErrorProneToken> tokens) {
        for (ErrorProneToken token : tokens) {
            for (ErrorProneComment comment : token.comments()) {
                if (!comment.getText().startsWith("/**")) continue;
                return comment;
            }
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(name)) continue;
            return null;
        }
        return null;
    }

    private static boolean isModifier(ErrorProneToken t) {
        return MODIFIERS.contains((Object)t.kind()) || t.kind().equals(Tokens.TokenKind.IDENTIFIER) && (t.name().contentEquals("sealed") || t.name().contentEquals("non"));
    }

    private static enum Position {
        BEFORE,
        AFTER,
        EITHER;

    }
}

