/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.function.Supplier;

@BugPattern(summary="Prefer InetAddress.getAllByName to APIs that convert a hostname to a single IP address", severity=BugPattern.SeverityLevel.WARNING)
public final class AddressSelection
extends BugChecker
implements BugChecker.NewClassTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CONSTRUCTORS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass("java.net.Socket").withParameters("java.lang.String", new String[]{"int"}), MethodMatchers.constructor().forClass("java.net.InetSocketAddress").withParameters("java.lang.String", new String[]{"int"})});
    private static final Matcher<ExpressionTree> METHODS = MethodMatchers.staticMethod().onClass("java.net.InetAddress").named("getByName").withParameters("java.lang.String", new String[0]);
    private static final ImmutableSet<String> LOOPBACK = ImmutableSet.of((Object)"127.0.0.1", (Object)"::1");
    private static final CharMatcher ASCII_DIGIT = CharMatcher.inRange((char)'0', (char)'9');

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!CONSTRUCTORS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = tree.getArguments().getFirst();
        return this.handleMatch(argument, argument, () -> {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.replace((Tree)argument, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"java.net.InetAddress") + ".getLoopbackAddress()");
            return fix.build();
        });
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHODS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        return this.handleMatch(argument, tree, () -> SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getLoopbackAddress", (VisitorState)state).toBuilder().delete((Tree)argument).build());
    }

    private Description handleMatch(ExpressionTree argument, ExpressionTree replacement, Supplier<SuggestedFix> fix) {
        String value = (String)ASTHelpers.constValue((Tree)argument, String.class);
        if (LOOPBACK.contains((Object)value)) {
            return this.describeMatch(replacement, (Fix)fix.get());
        }
        if (value == null || value.equals("localhost") || AddressSelection.isNumericIp(value)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(replacement);
    }

    private static boolean isNumericIp(String value) {
        if (value.isEmpty()) {
            return false;
        }
        if (value.contains(":")) {
            return true;
        }
        return ASCII_DIGIT.matches(value.charAt(0)) && ASCII_DIGIT.matches(value.charAt(value.length() - 1));
    }
}

