/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;

public class ClassAccessFilter
implements ClassVisitor {
    private final int requiredSetAccessFlags;
    private final int requiredUnsetAccessFlags;
    private final ClassVisitor classVisitor;

    public ClassAccessFilter(int requiredSetAccessFlags, int requiredUnsetAccessFlags, ClassVisitor classVisitor) {
        this.requiredSetAccessFlags = requiredSetAccessFlags;
        this.requiredUnsetAccessFlags = requiredUnsetAccessFlags;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        if (this.accepted(clazz.getAccessFlags())) {
            clazz.accept(this.classVisitor);
        }
    }

    private boolean accepted(int accessFlags) {
        return (this.requiredSetAccessFlags & ~accessFlags) == 0 && (this.requiredUnsetAccessFlags & accessFlags) == 0;
    }
}

