/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.lookup.PackageScope;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.PackageSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.RecordComponentSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineJavadoc;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineAnnotationMirror;
import com.google.turbine.processing.TurbineAnnotationProxy;
import com.google.turbine.processing.TurbineName;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.Nullable;

public abstract class TurbineElement
implements Element {
    protected final ModelFactory factory;
    private final Supplier<ImmutableList<AnnotationMirror>> annotationMirrors;

    public abstract Symbol sym();

    public abstract String javadoc();

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(@Nullable Object var1);

    protected <T> Supplier<T> memoize(Supplier<T> supplier) {
        return this.factory.memoize(supplier);
    }

    protected TurbineElement(final ModelFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.annotationMirrors = factory.memoize(new Supplier<ImmutableList<AnnotationMirror>>(){

            public ImmutableList<AnnotationMirror> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (AnnoInfo anno : TurbineElement.this.annos()) {
                    result.add((Object)TurbineAnnotationMirror.create(factory, anno));
                }
                return result.build();
            }
        });
    }

    static AnnoInfo getAnnotation(Iterable<AnnoInfo> annos, ClassSymbol sym) {
        for (AnnoInfo anno : annos) {
            if (!Objects.equals(anno.sym(), sym)) continue;
            return anno;
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return TurbineAnnotationProxy.getAnnotation(this.factory, this.annos(), annotationType);
    }

    @Override
    public final <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return TurbineAnnotationProxy.getAnnotationsByType((ModelFactory)this.factory, this.annos(), annotationType);
    }

    @Override
    public final List<? extends AnnotationMirror> getAnnotationMirrors() {
        return (List)this.annotationMirrors.get();
    }

    List<? extends AnnotationMirror> getAllAnnotationMirrors() {
        return this.getAnnotationMirrors();
    }

    protected abstract ImmutableList<AnnoInfo> annos();

    private static ImmutableSet<Modifier> asModifierSet(ModifierOwner modifierOwner, int access) {
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if ((access & 1) == 1) {
            modifiers.add(Modifier.PUBLIC);
        }
        if ((access & 4) == 4) {
            modifiers.add(Modifier.PROTECTED);
        }
        if ((access & 2) == 2) {
            modifiers.add(Modifier.PRIVATE);
        }
        if ((access & 0x400) == 1024) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if ((access & 0x10) == 16) {
            modifiers.add(Modifier.FINAL);
        }
        if ((access & 0x10000) == 65536) {
            modifiers.add(Modifier.DEFAULT);
        }
        if ((access & 8) == 8) {
            modifiers.add(Modifier.STATIC);
        }
        if ((access & 0x80) == 128) {
            switch (modifierOwner.ordinal()) {
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    modifiers.add(Modifier.TRANSIENT);
                }
            }
        }
        if ((access & 0x40) == 64) {
            modifiers.add(Modifier.VOLATILE);
        }
        if ((access & 0x20) == 32) {
            modifiers.add(Modifier.SYNCHRONIZED);
        }
        if ((access & 0x100) == 256) {
            modifiers.add(Modifier.NATIVE);
        }
        if ((access & 0x800) == 2048) {
            modifiers.add(Modifier.STRICTFP);
        }
        if ((access & 0x80000) == 524288) {
            modifiers.add(Modifier.SEALED);
        }
        if ((access & 0x100000) == 0x100000) {
            modifiers.add(Modifier.NON_SEALED);
        }
        return Sets.immutableEnumSet(modifiers);
    }

    private static enum ModifierOwner {
        TYPE,
        PARAMETER,
        FIELD,
        METHOD;

    }

    static class TurbineNoTypeElement
    implements TypeElement {
        private final ModelFactory factory;
        private final String name;

        public TurbineNoTypeElement(ModelFactory factory, String name) {
            this.factory = factory;
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public TypeMirror asType() {
            return this.factory.noType();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return ImmutableSet.of();
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.name.substring(this.name.lastIndexOf(46) + 1));
        }

        @Override
        public TypeMirror getSuperclass() {
            return this.factory.noType();
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            return ImmutableList.of();
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return ImmutableList.of();
        }

        @Override
        public Element getEnclosingElement() {
            int idx = this.name.lastIndexOf(46);
            String packageName = idx == -1 ? "" : this.name.substring(0, idx).replace('.', '/');
            return this.factory.packageElement(new PackageSymbol(packageName));
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ImmutableList.of();
        }

        @Override
        public NestingKind getNestingKind() {
            return NestingKind.TOP_LEVEL;
        }

        @Override
        public Name getQualifiedName() {
            return new TurbineName(this.name);
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            return ImmutableList.of();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> aClass) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> aClass) {
            return null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitType(this, p);
        }

        public String toString() {
            return this.getSimpleName().toString();
        }
    }

    static class TurbineRecordComponentElement
    extends TurbineElement
    implements RecordComponentElement {
        private final RecordComponentSymbol sym;
        private final Supplier<TypeBoundClass.RecordComponentInfo> info = this.memoize(new Supplier<TypeBoundClass.RecordComponentInfo>(){

            public TypeBoundClass.RecordComponentInfo get() {
                return factory.getRecordComponentInfo(sym);
            }
        });
        private final Supplier<TypeMirror> type = this.memoize(new Supplier<TypeMirror>(){

            public TypeMirror get() {
                return factory.asTypeMirror(this.info().type());
            }
        });
        private final Supplier<ExecutableElement> accessor = Suppliers.memoize((Supplier)new Supplier<ExecutableElement>(){

            public ExecutableElement get() {
                return factory.typeElement(sym.owner()).recordAccessor(sym);
            }
        });

        @Override
        public RecordComponentSymbol sym() {
            return this.sym;
        }

        @Override
        public String javadoc() {
            return null;
        }

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineRecordComponentElement)) return false;
            TurbineRecordComponentElement turbineRecordComponentElement = (TurbineRecordComponentElement)obj;
            if (!this.sym.equals(turbineRecordComponentElement.sym)) return false;
            return true;
        }

        @Nullable TypeBoundClass.RecordComponentInfo info() {
            return (TypeBoundClass.RecordComponentInfo)this.info.get();
        }

        public TurbineRecordComponentElement(ModelFactory factory, RecordComponentSymbol sym) {
            super(factory);
            this.sym = sym;
        }

        @Override
        public TypeMirror asType() {
            return (TypeMirror)this.type.get();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RECORD_COMPONENT;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return TurbineElement.asModifierSet(ModifierOwner.PARAMETER, this.info().access());
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.sym.name());
        }

        @Override
        public ExecutableElement getAccessor() {
            return (ExecutableElement)this.accessor.get();
        }

        @Override
        public Element getEnclosingElement() {
            return this.factory.typeElement(this.sym.owner());
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ImmutableList.of();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitRecordComponent(this, p);
        }

        public String toString() {
            return String.valueOf(this.sym.name());
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.info().annotations();
        }
    }

    static class TurbineParameterElement
    extends TurbineElement
    implements VariableElement {
        private final ParamSymbol sym;
        private final Supplier<TypeBoundClass.ParamInfo> info = this.memoize(new Supplier<TypeBoundClass.ParamInfo>(){

            public TypeBoundClass.ParamInfo get() {
                return factory.getParamInfo(sym);
            }
        });
        private final Supplier<TypeMirror> type = this.memoize(new Supplier<TypeMirror>(){

            public TypeMirror get() {
                return factory.asTypeMirror(this.info().type());
            }
        });

        @Override
        public ParamSymbol sym() {
            return this.sym;
        }

        @Override
        public String javadoc() {
            return null;
        }

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineParameterElement)) return false;
            TurbineParameterElement turbineParameterElement = (TurbineParameterElement)obj;
            if (!this.sym.equals(turbineParameterElement.sym)) return false;
            return true;
        }

        @Nullable TypeBoundClass.ParamInfo info() {
            return (TypeBoundClass.ParamInfo)this.info.get();
        }

        public TurbineParameterElement(ModelFactory factory, ParamSymbol sym) {
            super(factory);
            this.sym = sym;
        }

        @Override
        public Object getConstantValue() {
            return null;
        }

        @Override
        public TypeMirror asType() {
            return (TypeMirror)this.type.get();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return TurbineElement.asModifierSet(ModifierOwner.PARAMETER, this.info().access());
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.sym.name());
        }

        @Override
        public Element getEnclosingElement() {
            return this.factory.executableElement(this.sym.owner());
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ImmutableList.of();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitVariable(this, p);
        }

        public String toString() {
            return String.valueOf(this.sym.name());
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.info().annotations();
        }
    }

    static class TurbinePackageElement
    extends TurbineElement
    implements PackageElement {
        private final PackageSymbol sym;
        private final Supplier<TypeBoundClass> info = this.memoize(new Supplier<TypeBoundClass>(){

            public TypeBoundClass get() {
                return factory.getSymbol(new ClassSymbol(sym.binaryName() + "/package-info"));
            }
        });
        private final Supplier<ImmutableList<AnnoInfo>> annos = this.memoize(new Supplier<ImmutableList<AnnoInfo>>(){

            public ImmutableList<AnnoInfo> get() {
                TypeBoundClass info = this.info();
                return info != null ? info.annotations() : ImmutableList.of();
            }
        });

        public TurbinePackageElement(ModelFactory factory, PackageSymbol sym) {
            super(factory);
            this.sym = sym;
        }

        @Override
        public Name getQualifiedName() {
            return new TurbineName(this.sym.toString());
        }

        @Override
        public boolean isUnnamed() {
            return this.sym.binaryName().isEmpty();
        }

        @Override
        public TypeMirror asType() {
            return this.factory.packageType(this.sym);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return ImmutableSet.of();
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.sym.binaryName().substring(this.sym.binaryName().lastIndexOf(47) + 1));
        }

        @Override
        public Element getEnclosingElement() {
            return null;
        }

        public List<TurbineTypeElement> getEnclosedElements() {
            ImmutableSet.Builder result = ImmutableSet.builder();
            PackageScope scope = this.factory.tli().lookupPackage(this.sym.binaryName());
            Objects.requireNonNull(scope);
            for (ClassSymbol key : scope.classes()) {
                if (key.binaryName().contains("$") && this.factory.getSymbol(key).owner() != null || key.simpleName().equals("package-info")) continue;
                result.add((Object)this.factory.typeElement(key));
            }
            return result.build().asList();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        public PackageSymbol sym() {
            return this.sym;
        }

        @Override
        public @Nullable String javadoc() {
            TypeBoundClass info = this.info();
            if (!(info instanceof SourceTypeBoundClass)) {
                return null;
            }
            SourceTypeBoundClass sourceTypeBoundClass = (SourceTypeBoundClass)info;
            TurbineJavadoc javadoc = sourceTypeBoundClass.decl().javadoc();
            if (javadoc == null) {
                return null;
            }
            return javadoc.value();
        }

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbinePackageElement)) return false;
            TurbinePackageElement turbinePackageElement = (TurbinePackageElement)obj;
            if (!this.sym.equals(turbinePackageElement.sym)) return false;
            return true;
        }

        @Nullable TypeBoundClass info() {
            return (TypeBoundClass)this.info.get();
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return (ImmutableList)this.annos.get();
        }

        public String toString() {
            return this.sym.toString();
        }
    }

    static class TurbineFieldElement
    extends TurbineElement
    implements VariableElement {
        private final FieldSymbol sym;
        private final Supplier<TypeBoundClass.FieldInfo> info = this.memoize(new Supplier<TypeBoundClass.FieldInfo>(){

            public TypeBoundClass.FieldInfo get() {
                return factory.getFieldInfo(sym);
            }
        });

        public String toString() {
            return this.sym.name();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineFieldElement)) return false;
            TurbineFieldElement turbineFieldElement = (TurbineFieldElement)obj;
            if (!this.sym.equals(turbineFieldElement.sym)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        @Override
        public FieldSymbol sym() {
            return this.sym;
        }

        @Override
        public @Nullable String javadoc() {
            Tree.VarDecl decl = this.info().decl();
            if (decl == null) {
                return null;
            }
            TurbineJavadoc javadoc = decl.javadoc();
            if (javadoc == null) {
                return null;
            }
            return javadoc.value();
        }

        @Nullable TypeBoundClass.FieldInfo info() {
            return (TypeBoundClass.FieldInfo)this.info.get();
        }

        TurbineFieldElement(ModelFactory factory, FieldSymbol sym) {
            super(factory);
            this.sym = sym;
        }

        @Override
        public Object getConstantValue() {
            if (this.info().value() == null) {
                return null;
            }
            return this.info().value().getValue();
        }

        @Override
        public TypeMirror asType() {
            return this.factory.asTypeMirror(this.info().type());
        }

        @Override
        public ElementKind getKind() {
            return (this.info().access() & 0x4000) == 16384 ? ElementKind.ENUM_CONSTANT : ElementKind.FIELD;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return TurbineElement.asModifierSet(ModifierOwner.FIELD, this.info().access());
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.sym.name());
        }

        @Override
        public Element getEnclosingElement() {
            return this.factory.typeElement(this.sym.owner());
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ImmutableList.of();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitVariable(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.info().annotations();
        }
    }

    static class TurbineExecutableElement
    extends TurbineElement
    implements ExecutableElement {
        private final MethodSymbol sym;
        private final Supplier<TypeBoundClass.MethodInfo> info = this.memoize(new Supplier<TypeBoundClass.MethodInfo>(){

            public TypeBoundClass.MethodInfo get() {
                return factory.getMethodInfo(sym);
            }
        });
        private final Supplier<ImmutableList<VariableElement>> parameters = this.memoize(new Supplier<ImmutableList<VariableElement>>(){

            public ImmutableList<VariableElement> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (TypeBoundClass.ParamInfo param : this.info().parameters()) {
                    if (param.synthetic()) continue;
                    result.add((Object)factory.parameterElement(param.sym()));
                }
                return result.build();
            }
        });

        @Nullable TypeBoundClass.MethodInfo info() {
            return (TypeBoundClass.MethodInfo)this.info.get();
        }

        TurbineExecutableElement(ModelFactory factory, MethodSymbol sym) {
            super(factory);
            this.sym = sym;
        }

        @Override
        public MethodSymbol sym() {
            return this.sym;
        }

        @Override
        public @Nullable String javadoc() {
            Tree.MethDecl decl = this.info().decl();
            if (decl == null) {
                return null;
            }
            TurbineJavadoc javadoc = decl.javadoc();
            if (javadoc == null) {
                return null;
            }
            return javadoc.value();
        }

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineExecutableElement)) return false;
            TurbineExecutableElement turbineExecutableElement = (TurbineExecutableElement)obj;
            if (!this.sym.equals(turbineExecutableElement.sym)) return false;
            return true;
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (Map.Entry p : this.info().tyParams().entrySet()) {
                result.add((Object)this.factory.typeParameterElement((TyVarSymbol)p.getKey()));
            }
            return result.build();
        }

        @Override
        public TypeMirror getReturnType() {
            return this.factory.asTypeMirror(this.info().returnType());
        }

        @Override
        public List<? extends VariableElement> getParameters() {
            return (List)this.parameters.get();
        }

        public String toString() {
            TypeBoundClass.MethodInfo info = this.info();
            StringBuilder sb = new StringBuilder();
            if (!info.tyParams().isEmpty()) {
                sb.append('<');
                Joiner.on((char)',').appendTo(sb, (Iterable)info.tyParams().keySet());
                sb.append('>');
            }
            if (this.getKind() == ElementKind.CONSTRUCTOR) {
                sb.append(info.sym().owner().simpleName());
            } else {
                sb.append(info.sym().name());
            }
            sb.append('(');
            boolean first = true;
            for (TypeBoundClass.ParamInfo p : info.parameters()) {
                if (!first) {
                    sb.append(',');
                }
                sb.append(p.type());
                first = false;
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public TypeMirror getReceiverType() {
            return this.info().receiver() != null ? this.factory.asTypeMirror(this.info().receiver().type()) : this.factory.noType();
        }

        @Override
        public boolean isVarArgs() {
            return (this.info().access() & 0x80) == 128;
        }

        @Override
        public boolean isDefault() {
            return (this.info().access() & 0x10000) == 65536;
        }

        @Override
        public List<? extends TypeMirror> getThrownTypes() {
            return this.factory.asTypeMirrors((Iterable<? extends Type>)this.info().exceptions());
        }

        @Override
        public AnnotationValue getDefaultValue() {
            return this.info().defaultValue() != null ? TurbineAnnotationMirror.annotationValue(this.factory, this.info().defaultValue()) : null;
        }

        @Override
        public TypeMirror asType() {
            return this.factory.asTypeMirror(this.info().asType());
        }

        @Override
        public ElementKind getKind() {
            return this.sym.name().equals("<init>") ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return TurbineElement.asModifierSet(ModifierOwner.METHOD, this.info().access());
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.info().sym().name());
        }

        @Override
        public Element getEnclosingElement() {
            return this.factory.typeElement(this.info().sym().owner());
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ImmutableList.of();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.info().annotations();
        }
    }

    static class TurbineTypeParameterElement
    extends TurbineElement
    implements TypeParameterElement {
        private final TyVarSymbol sym;
        private final Supplier<TypeBoundClass.TyVarInfo> info = this.memoize(new Supplier<TypeBoundClass.TyVarInfo>(){

            public TypeBoundClass.TyVarInfo get() {
                return factory.getTyVarInfo(sym);
            }
        });

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineTypeParameterElement)) return false;
            TurbineTypeParameterElement turbineTypeParameterElement = (TurbineTypeParameterElement)obj;
            if (!this.sym.equals(turbineTypeParameterElement.sym)) return false;
            return true;
        }

        public TurbineTypeParameterElement(ModelFactory factory, TyVarSymbol sym) {
            super(factory);
            this.sym = sym;
        }

        private @Nullable TypeBoundClass.TyVarInfo info() {
            return (TypeBoundClass.TyVarInfo)this.info.get();
        }

        public String toString() {
            return this.sym.name();
        }

        @Override
        public Element getGenericElement() {
            return this.factory.element(this.sym.owner());
        }

        @Override
        public List<? extends TypeMirror> getBounds() {
            ImmutableList bounds = this.info().upperBound().bounds();
            return this.factory.asTypeMirrors((Iterable<? extends Type>)(bounds.isEmpty() ? ImmutableList.of((Object)Type.ClassTy.OBJECT) : bounds));
        }

        @Override
        public TypeMirror asType() {
            return this.factory.asTypeMirror(Type.TyVar.create(this.sym, (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.TYPE_PARAMETER;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return ImmutableSet.of();
        }

        @Override
        public Name getSimpleName() {
            return new TurbineName(this.sym.name());
        }

        @Override
        public Element getEnclosingElement() {
            return this.getGenericElement();
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ImmutableList.of();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitTypeParameter(this, p);
        }

        @Override
        public TyVarSymbol sym() {
            return this.sym;
        }

        @Override
        public String javadoc() {
            return null;
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.info().annotations();
        }
    }

    static class TurbineTypeElement
    extends TurbineElement
    implements TypeElement {
        private final ClassSymbol sym;
        private final Supplier<TypeBoundClass> info;
        private final Supplier<TurbineName> qualifiedName = this.memoize(new Supplier<TurbineName>(){

            public TurbineName get() {
                TypeBoundClass info = this.info();
                if (info == null || info.owner() == null) {
                    return new TurbineName(sym.toString());
                }
                ClassSymbol sym = this.sym();
                ArrayDeque<String> flat = new ArrayDeque<String>();
                while (info.owner() != null) {
                    flat.addFirst(sym.binaryName().substring(info.owner().binaryName().length() + 1));
                    sym = info.owner();
                    info = factory.getSymbol(sym);
                }
                flat.addFirst(sym.toString());
                return new TurbineName(Joiner.on((char)'.').join(flat));
            }
        });
        private final Supplier<TypeMirror> superclass = this.memoize(new Supplier<TypeMirror>(){

            public TypeMirror get() {
                TypeBoundClass info = this.infoNonNull();
                return switch (info.kind()) {
                    default -> throw new MatchException(null, null);
                    case TurbineTyKind.CLASS, TurbineTyKind.ENUM, TurbineTyKind.RECORD -> {
                        if (info.superClassType() != null) {
                            yield factory.asTypeMirror(info.superClassType());
                        }
                        yield factory.noType();
                    }
                    case TurbineTyKind.INTERFACE, TurbineTyKind.ANNOTATION -> factory.noType();
                };
            }
        });
        private final Supplier<List<TypeMirror>> interfaces = this.memoize(new Supplier<List<TypeMirror>>(){

            public List<TypeMirror> get() {
                return factory.asTypeMirrors((Iterable<? extends Type>)this.infoNonNull().interfaceTypes());
            }
        });
        private final Supplier<ImmutableList<TypeParameterElement>> typeParameters = this.memoize(new Supplier<ImmutableList<TypeParameterElement>>(){

            public ImmutableList<TypeParameterElement> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (TyVarSymbol p : this.infoNonNull().typeParameters().values()) {
                    result.add((Object)factory.typeParameterElement(p));
                }
                return result.build();
            }
        });
        private final Supplier<TypeMirror> type = this.memoize(new Supplier<TypeMirror>(){

            public TypeMirror get() {
                return factory.asTypeMirror(this.asGenericType(sym));
            }

            Type asGenericType(ClassSymbol symbol) {
                TypeBoundClass info = this.info();
                if (info == null) {
                    return Type.ErrorTy.create(this.getQualifiedName().toString(), (ImmutableList<Type>)ImmutableList.of());
                }
                ArrayDeque<Type.ClassTy.SimpleClassTy> simples = new ArrayDeque<Type.ClassTy.SimpleClassTy>();
                simples.addFirst(this.simple(symbol, info));
                while (info.owner() != null && (info.access() & 8) == 0) {
                    symbol = info.owner();
                    info = factory.getSymbol(symbol);
                    simples.addFirst(this.simple(symbol, info));
                }
                return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.copyOf(simples));
            }

            private Type.ClassTy.SimpleClassTy simple(ClassSymbol sym, TypeBoundClass info) {
                ImmutableList.Builder args = ImmutableList.builder();
                for (TyVarSymbol t : info.typeParameters().values()) {
                    args.add((Object)Type.TyVar.create(t, (ImmutableList<AnnoInfo>)ImmutableList.of()));
                }
                return Type.ClassTy.SimpleClassTy.create(sym, (ImmutableList<Type>)args.build(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        });
        private final Supplier<TurbineName> simpleName = this.memoize(new Supplier<TurbineName>(){

            public TurbineName get() {
                TypeBoundClass info = this.info();
                if (info == null || info.owner() == null) {
                    return new TurbineName(sym.simpleName());
                }
                return new TurbineName(sym.binaryName().substring(info.owner().binaryName().length() + 1));
            }
        });
        private final Supplier<Element> enclosing = this.memoize(new Supplier<Element>(){

            public Element get() {
                return this.getNestingKind().equals((Object)NestingKind.TOP_LEVEL) ? factory.packageElement(sym.owner()) : factory.typeElement(this.info().owner());
            }
        });
        private final Supplier<ImmutableList<TypeMirror>> permits = this.memoize(new Supplier<ImmutableList<TypeMirror>>(){

            public ImmutableList<TypeMirror> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (ClassSymbol p : this.infoNonNull().permits()) {
                    result.add((Object)factory.asTypeMirror(Type.ClassTy.asNonParametricClassTy(p)));
                }
                return result.build();
            }
        });
        private final Supplier<ImmutableList<Element>> enclosed = this.memoize(new Supplier<ImmutableList<Element>>(){

            public ImmutableList<Element> get() {
                TypeBoundClass info = this.infoNonNull();
                ImmutableList.Builder result = ImmutableList.builder();
                for (TypeBoundClass.RecordComponentInfo component : info.components()) {
                    result.add((Object)factory.recordComponentElement(component.sym()));
                }
                for (TypeBoundClass.FieldInfo field : info.fields()) {
                    result.add((Object)factory.fieldElement(field.sym()));
                }
                for (TypeBoundClass.MethodInfo method : info.methods()) {
                    result.add((Object)factory.executableElement(method.sym()));
                }
                for (ClassSymbol child : info.children().values()) {
                    result.add((Object)factory.typeElement(child));
                }
                return result.build();
            }
        });
        private final Supplier<ImmutableMap<RecordComponentSymbol, MethodSymbol>> recordAccessors = this.memoize(new Supplier<ImmutableMap<RecordComponentSymbol, MethodSymbol>>(){

            public ImmutableMap<RecordComponentSymbol, MethodSymbol> get() {
                HashMap<String, MethodSymbol> methods = new HashMap<String, MethodSymbol>();
                for (TypeBoundClass.MethodInfo method : this.info().methods()) {
                    if (!method.parameters().isEmpty()) continue;
                    methods.put(method.name(), method.sym());
                }
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (TypeBoundClass.RecordComponentInfo component : this.info().components()) {
                    result.put((Object)component.sym(), (Object)((MethodSymbol)methods.get(component.name())));
                }
                return result.buildOrThrow();
            }
        });
        private final Supplier<ImmutableList<RecordComponentElement>> recordComponents = this.memoize(new Supplier<ImmutableList<RecordComponentElement>>(){

            public ImmutableList<RecordComponentElement> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (TypeBoundClass.RecordComponentInfo component : this.info().components()) {
                    result.add((Object)factory.recordComponentElement(component.sym()));
                }
                return result.build();
            }
        });

        @Override
        public int hashCode() {
            return this.sym.hashCode();
        }

        TurbineTypeElement(final ModelFactory factory, final ClassSymbol sym) {
            super(factory);
            this.sym = Objects.requireNonNull(sym);
            this.info = this.memoize(new Supplier<TypeBoundClass>(){

                public TypeBoundClass get() {
                    return factory.getSymbol(sym);
                }
            });
        }

        @Nullable TypeBoundClass info() {
            return (TypeBoundClass)this.info.get();
        }

        TypeBoundClass infoNonNull() {
            TypeBoundClass info = this.info();
            if (info == null) {
                throw TurbineError.format(null, TurbineError.ErrorKind.SYMBOL_NOT_FOUND, this.sym);
            }
            return info;
        }

        @Override
        public NestingKind getNestingKind() {
            TypeBoundClass info = this.info();
            return info != null && info.owner() != null ? NestingKind.MEMBER : NestingKind.TOP_LEVEL;
        }

        @Override
        public Name getQualifiedName() {
            return (Name)this.qualifiedName.get();
        }

        @Override
        public TypeMirror getSuperclass() {
            return (TypeMirror)this.superclass.get();
        }

        public String toString() {
            return this.getQualifiedName().toString();
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            return (List)this.interfaces.get();
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return (List)this.typeParameters.get();
        }

        @Override
        public TypeMirror asType() {
            return (TypeMirror)this.type.get();
        }

        @Override
        public ElementKind getKind() {
            TypeBoundClass info = this.infoNonNull();
            return switch (info.kind()) {
                default -> throw new MatchException(null, null);
                case TurbineTyKind.CLASS -> ElementKind.CLASS;
                case TurbineTyKind.INTERFACE -> ElementKind.INTERFACE;
                case TurbineTyKind.ENUM -> ElementKind.ENUM;
                case TurbineTyKind.ANNOTATION -> ElementKind.ANNOTATION_TYPE;
                case TurbineTyKind.RECORD -> ElementKind.RECORD;
            };
        }

        @Override
        public Set<Modifier> getModifiers() {
            return TurbineElement.asModifierSet(ModifierOwner.TYPE, this.infoNonNull().access() & 0xFFFFFFDF);
        }

        @Override
        public Name getSimpleName() {
            return (Name)this.simpleName.get();
        }

        @Override
        public Element getEnclosingElement() {
            return (Element)this.enclosing.get();
        }

        @Override
        public List<? extends TypeMirror> getPermittedSubclasses() {
            return (List)this.permits.get();
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return (List)this.enclosed.get();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitType(this, p);
        }

        @Override
        public ClassSymbol sym() {
            return this.sym;
        }

        @Override
        public @Nullable String javadoc() {
            TypeBoundClass info = this.info();
            if (!(info instanceof SourceTypeBoundClass)) {
                return null;
            }
            SourceTypeBoundClass sourceTypeBoundClass = (SourceTypeBoundClass)info;
            TurbineJavadoc javadoc = sourceTypeBoundClass.decl().javadoc();
            if (javadoc == null) {
                return null;
            }
            return javadoc.value();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineTypeElement)) return false;
            TurbineTypeElement turbineTypeElement = (TurbineTypeElement)obj;
            if (!this.sym.equals(turbineTypeElement.sym)) return false;
            return true;
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.infoNonNull().annotations();
        }

        @Override
        public final <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            TypeBoundClass info;
            ClassSymbol sym = new ClassSymbol(annotationType.getName().replace('.', '/'));
            AnnoInfo anno = TurbineTypeElement.getAnnotation(this.annos(), sym);
            if (anno != null) {
                return TurbineAnnotationProxy.create(this.factory, annotationType, anno);
            }
            if (!this.isAnnotationInherited(sym)) {
                return null;
            }
            ClassSymbol superclass = this.infoNonNull().superclass();
            while (superclass != null && (info = this.factory.getSymbol(superclass)) != null) {
                anno = TurbineTypeElement.getAnnotation(info.annotations(), sym);
                if (anno != null) {
                    return TurbineAnnotationProxy.create(this.factory, annotationType, anno);
                }
                superclass = info.superclass();
            }
            return null;
        }

        @Override
        List<? extends AnnotationMirror> getAllAnnotationMirrors() {
            TypeBoundClass i;
            LinkedHashMap<ClassSymbol, AnnotationMirror> result = new LinkedHashMap<ClassSymbol, AnnotationMirror>();
            for (AnnoInfo anno : this.annos()) {
                result.put(anno.sym(), TurbineAnnotationMirror.create(this.factory, anno));
            }
            ClassSymbol superclass = this.infoNonNull().superclass();
            while (superclass != null && (i = this.factory.getSymbol(superclass)) != null) {
                for (AnnoInfo anno : i.annotations()) {
                    this.addAnnotationFromSuper(result, anno);
                }
                superclass = i.superclass();
            }
            return ImmutableList.copyOf(result.values());
        }

        private void addAnnotationFromSuper(Map<ClassSymbol, AnnotationMirror> result, AnnoInfo anno) {
            if (!this.isAnnotationInherited(anno.sym())) {
                return;
            }
            if (result.containsKey(anno.sym())) {
                return;
            }
            result.put(anno.sym(), TurbineAnnotationMirror.create(this.factory, anno));
        }

        private boolean isAnnotationInherited(ClassSymbol sym) {
            TypeBoundClass annoInfo = this.factory.getSymbol(sym);
            if (annoInfo == null) {
                return false;
            }
            for (AnnoInfo anno : annoInfo.annotations()) {
                if (!anno.sym().equals(ClassSymbol.INHERITED)) continue;
                return true;
            }
            return false;
        }

        ExecutableElement recordAccessor(RecordComponentSymbol component) {
            return this.factory.executableElement((MethodSymbol)((ImmutableMap)this.recordAccessors.get()).get((Object)component));
        }

        @Override
        public List<? extends RecordComponentElement> getRecordComponents() {
            return (List)this.recordComponents.get();
        }
    }
}

