/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.errorprone.fixes.ErrorProneEndPosTable;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public record AppliedFix(String snippet, boolean isRemoveLine) {
    public static final int MAX_LINE_LENGTH = 100;

    public static @Nullable AppliedFix apply(CharSequence source, ErrorProneEndPosTable endPositions, Fix suggestedFix) {
        ImmutableSet<Replacement> replacements = AppliedFix.ascending(suggestedFix.getReplacements(endPositions));
        if (replacements.isEmpty()) {
            return null;
        }
        String snippet = AppliedFix.snippet(source, replacements);
        if (snippet.isEmpty()) {
            return new AppliedFix("to remove this line", true);
        }
        return new AppliedFix(snippet, false);
    }

    private static String snippet(CharSequence sourceSequence, ImmutableSet<Replacement> replacements) {
        Replacement firstEdit = (Replacement)replacements.iterator().next();
        int startOffset = Math.max(0, firstEdit.startPosition() - 100);
        int endOffset = Math.min(firstEdit.endPosition() + 100, sourceSequence.length());
        Range trimmed = Range.closedOpen((Comparable)Integer.valueOf(startOffset), (Comparable)Integer.valueOf(endOffset));
        ArrayList<Replacement> shiftedReplacements = new ArrayList<Replacement>();
        for (Replacement replacement : replacements) {
            if (!replacement.range().isConnected(trimmed)) continue;
            if (replacement.endPosition() > endOffset) {
                endOffset = replacement.endPosition();
            }
            shiftedReplacements.add(Replacement.create(replacement.startPosition() - startOffset, replacement.endPosition() - startOffset, replacement.replaceWith()));
        }
        String replaced = AppliedFix.applyReplacements(sourceSequence.subSequence(startOffset, endOffset), shiftedReplacements);
        return AppliedFix.firstEditedLine(replaced, (Replacement)shiftedReplacements.getFirst());
    }

    public static String applyReplacements(CharSequence source, ErrorProneEndPosTable endPositions, Fix fix) {
        return AppliedFix.applyReplacements(source, fix.getReplacements(endPositions));
    }

    private static String applyReplacements(CharSequence source, Collection<Replacement> replacements) {
        StringBuilder replaced = new StringBuilder();
        int positionInOriginal = 0;
        for (Replacement repl : replacements) {
            Preconditions.checkArgument((repl.endPosition() <= source.length() ? 1 : 0) != 0, (String)"End [%s] should not exceed source length [%s]", (int)repl.endPosition(), (int)source.length());
            replaced.append(source, positionInOriginal, repl.startPosition());
            replaced.append(repl.replaceWith());
            positionInOriginal = repl.endPosition();
        }
        replaced.append(source, positionInOriginal, source.length());
        return replaced.toString();
    }

    private static ImmutableSet<Replacement> ascending(Set<Replacement> set) {
        Replacements replacements = new Replacements();
        set.forEach(replacements::add);
        return replacements.ascending();
    }

    private static String firstEditedLine(String content, Replacement firstEdit) {
        int startOfFirstEditedLine = content.lastIndexOf("\n", firstEdit.startPosition() - 1);
        int endOfFirstEditedLine = content.indexOf("\n", firstEdit.startPosition());
        if (startOfFirstEditedLine == -1) {
            startOfFirstEditedLine = 0;
        }
        if (endOfFirstEditedLine == -1) {
            endOfFirstEditedLine = content.length();
        }
        String snippet = content.substring(startOfFirstEditedLine, endOfFirstEditedLine);
        if ((snippet = snippet.trim()).contains("//")) {
            snippet = snippet.substring(0, snippet.indexOf("//")).trim();
        }
        return snippet;
    }
}

