/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.RefactoringCollection;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Options;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.jspecify.annotations.Nullable;

public class BaseErrorProneJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javacTool;
    private final ScannerSupplier scannerSupplier;

    public BaseErrorProneJavaCompiler(ScannerSupplier scannerSupplier) {
        this(JavacTool.create(), scannerSupplier);
    }

    BaseErrorProneJavaCompiler(JavaCompiler javacTool, ScannerSupplier scannerSupplier) {
        this.javacTool = javacTool;
        this.scannerSupplier = scannerSupplier;
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        ErrorProneOptions errorProneOptions = ErrorProneOptions.processArgs(options);
        ImmutableList<String> javacOpts = errorProneOptions.getRemainingArgs();
        javacOpts = BaseErrorProneJavaCompiler.defaultToLatestSupportedLanguageLevel(javacOpts);
        javacOpts = BaseErrorProneJavaCompiler.setCompilePolicyToByFile(javacOpts);
        javacOpts = BaseErrorProneJavaCompiler.setShouldStopIfErrorPolicyToFlow(javacOpts);
        javacOpts = BaseErrorProneJavaCompiler.setAddTypeAnnotationsToSymbol(javacOpts);
        JavacTask task = (JavacTask)this.javacTool.getTask(out, fileManager, diagnosticListener, (Iterable<String>)javacOpts, classes, compilationUnits);
        BaseErrorProneJavaCompiler.addTaskListener(task, this.scannerSupplier, errorProneOptions);
        return task;
    }

    static void addTaskListener(JavacTask javacTask, ScannerSupplier scannerSupplier, ErrorProneOptions errorProneOptions) {
        Context context = ((BasicJavacTask)javacTask).getContext();
        BaseErrorProneJavaCompiler.setupMessageBundle(context);
        Options options = Options.instance(context);
        BaseErrorProneJavaCompiler.checkCompilePolicy(options.get("compilePolicy"));
        BaseErrorProneJavaCompiler.checkShouldStopIfErrorPolicy(options.get("should-stop.ifError"));
        BaseErrorProneJavaCompiler.checkAddTypeAnnotationsToSymbol(options.get("addTypeAnnotationsToSymbol"));
        RefactoringCollection[] refactoringCollection = new RefactoringCollection[]{null};
        javacTask.addTaskListener(ErrorProneAnalyzer.createAnalyzer(scannerSupplier, errorProneOptions, context, refactoringCollection));
        if (refactoringCollection[0] != null) {
            javacTask.addTaskListener(new ErrorProneAnalyzer.RefactoringTask(context, refactoringCollection[0]));
        }
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.javacTool.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int isSupportedOption(String option) {
        int numberOfArgs = this.javacTool.isSupportedOption(option);
        if (numberOfArgs != -1) {
            return numberOfArgs;
        }
        return ErrorProneOptions.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.javacTool.run(in, out, err, arguments);
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        EnumSet<SourceVersion> filtered = EnumSet.noneOf(SourceVersion.class);
        for (SourceVersion version : this.javacTool.getSourceVersions()) {
            if (version.compareTo(SourceVersion.RELEASE_6) < 0) continue;
            filtered.add(version);
        }
        return filtered;
    }

    private static ImmutableList<String> defaultToLatestSupportedLanguageLevel(ImmutableList<String> args) {
        String overrideLanguageLevel;
        switch (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) {
            case "1.7": {
                overrideLanguageLevel = "7";
                break;
            }
            case "1.8": {
                overrideLanguageLevel = "8";
                break;
            }
            default: {
                return args;
            }
        }
        return ImmutableList.builder().add((Object[])new String[]{"-Xlint:-options", "-source", overrideLanguageLevel, "-target", overrideLanguageLevel}).addAll(args).build();
    }

    static void checkCompilePolicy(@Nullable String compilePolicy) {
        if (compilePolicy == null) {
            throw new InvalidCommandLineOptionException("The default compilation policy (by-todo) is not supported by Error Prone, pass -XDcompilePolicy=simple instead");
        }
        switch (compilePolicy) {
            case "byfile": 
            case "simple": {
                break;
            }
            default: {
                throw new InvalidCommandLineOptionException(String.format("-XDcompilePolicy=%s is not supported by Error Prone, pass -XDcompilePolicy=simple instead", compilePolicy));
            }
        }
    }

    private static ImmutableList<String> setCompilePolicyToByFile(ImmutableList<String> args) {
        for (String arg : args) {
            if (!arg.startsWith("-XDcompilePolicy")) continue;
            String value = arg.substring(arg.indexOf(61) + 1);
            BaseErrorProneJavaCompiler.checkCompilePolicy(value);
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-XDcompilePolicy=simple").build();
    }

    private static void checkShouldStopIfErrorPolicy(String value) {
        if (value == null) {
            throw new InvalidCommandLineOptionException("The default --should-stop=ifError policy (INIT) is not supported by Error Prone, pass --should-stop=ifError=FLOW instead");
        }
        CompileStates.CompileState state = CompileStates.CompileState.valueOf(value);
        if (CompileStates.CompileState.FLOW.isAfter(state)) {
            throw new InvalidCommandLineOptionException(String.format("--should-stop=ifError=%s is not supported by Error Prone, pass --should-stop=ifError=FLOW instead", value));
        }
    }

    private static ImmutableList<String> setShouldStopIfErrorPolicyToFlow(ImmutableList<String> args) {
        for (String arg : args) {
            if (!arg.startsWith("--should-stop=ifError") && !arg.startsWith("-XDshould-stop.ifError")) continue;
            String value = arg.substring(arg.lastIndexOf(61) + 1);
            BaseErrorProneJavaCompiler.checkShouldStopIfErrorPolicy(value);
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"--should-stop=ifError=FLOW").build();
    }

    private static ImmutableList<String> setAddTypeAnnotationsToSymbol(ImmutableList<String> args) {
        for (String arg : args) {
            if (!arg.startsWith("-XDaddTypeAnnotationsToSymbol")) continue;
            String value = arg.substring(arg.indexOf(61) + 1);
            BaseErrorProneJavaCompiler.checkAddTypeAnnotationsToSymbol(value);
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-XDaddTypeAnnotationsToSymbol=true").build();
    }

    private static void checkAddTypeAnnotationsToSymbol(String value) {
        if (value == null) {
            if (Runtime.version().feature() <= 21) {
                throw new InvalidCommandLineOptionException("-XDaddTypeAnnotationsToSymbol=true is required by Error Prone on JDK 21");
            }
            return;
        }
        if (!Boolean.parseBoolean(value)) {
            throw new InvalidCommandLineOptionException("-XDaddTypeAnnotationsToSymbol must be set to true, was: " + value);
        }
    }

    public static void setupMessageBundle(Context context) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.google.errorprone.errors");
        JavacMessages.instance(context).add(l -> bundle);
    }
}

