// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/rpc/error_details.proto
// Protobuf Java Version: 4.33.4

package com.google.rpc;

/**
 * <pre>
 * Describes how a quota check failed.
 *
 * For example if a daily limit was exceeded for the calling project,
 * a service could respond with a QuotaFailure detail containing the project
 * id and the description of the quota limit that was exceeded.  If the
 * calling project hasn't enabled the service in the developer console, then
 * a service could respond with the project id and set `service_disabled`
 * to true.
 *
 * Also see RetryInfo and Help types for other details about handling a
 * quota failure.
 * </pre>
 *
 * Protobuf type {@code google.rpc.QuotaFailure}
 */
@com.google.protobuf.Generated
public final class QuotaFailure extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.rpc.QuotaFailure)
    QuotaFailureOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 33,
      /* patch= */ 4,
      /* suffix= */ "",
      "QuotaFailure");
  }
  // Use QuotaFailure.newBuilder() to construct.
  private QuotaFailure(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private QuotaFailure() {
    violations_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.rpc.QuotaFailure.class, com.google.rpc.QuotaFailure.Builder.class);
  }

  public interface ViolationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.rpc.QuotaFailure.Violation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The subject on which the quota check failed.
     * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
     * developer project id&gt;".
     * </pre>
     *
     * <code>string subject = 1;</code>
     * @return The subject.
     */
    java.lang.String getSubject();
    /**
     * <pre>
     * The subject on which the quota check failed.
     * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
     * developer project id&gt;".
     * </pre>
     *
     * <code>string subject = 1;</code>
     * @return The bytes for subject.
     */
    com.google.protobuf.ByteString
        getSubjectBytes();

    /**
     * <pre>
     * A description of how the quota check failed. Clients can use this
     * description to find more about the quota configuration in the service's
     * public documentation, or find the relevant quota limit to adjust through
     * developer console.
     *
     * For example: "Service disabled" or "Daily Limit for read operations
     * exceeded".
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     * <pre>
     * A description of how the quota check failed. Clients can use this
     * description to find more about the quota configuration in the service's
     * public documentation, or find the relevant quota limit to adjust through
     * developer console.
     *
     * For example: "Service disabled" or "Daily Limit for read operations
     * exceeded".
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <pre>
     * The API Service from which the `QuotaFailure.Violation` orginates. In
     * some cases, Quota issues originate from an API Service other than the one
     * that was called. In other words, a dependency of the called API Service
     * could be the cause of the `QuotaFailure`, and this field would have the
     * dependency API service name.
     *
     * For example, if the called API is Kubernetes Engine API
     * (container.googleapis.com), and a quota violation occurs in the
     * Kubernetes Engine API itself, this field would be
     * "container.googleapis.com". On the other hand, if the quota violation
     * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
     * API (compute.googleapis.com), this field would be
     * "compute.googleapis.com".
     * </pre>
     *
     * <code>string api_service = 3;</code>
     * @return The apiService.
     */
    java.lang.String getApiService();
    /**
     * <pre>
     * The API Service from which the `QuotaFailure.Violation` orginates. In
     * some cases, Quota issues originate from an API Service other than the one
     * that was called. In other words, a dependency of the called API Service
     * could be the cause of the `QuotaFailure`, and this field would have the
     * dependency API service name.
     *
     * For example, if the called API is Kubernetes Engine API
     * (container.googleapis.com), and a quota violation occurs in the
     * Kubernetes Engine API itself, this field would be
     * "container.googleapis.com". On the other hand, if the quota violation
     * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
     * API (compute.googleapis.com), this field would be
     * "compute.googleapis.com".
     * </pre>
     *
     * <code>string api_service = 3;</code>
     * @return The bytes for apiService.
     */
    com.google.protobuf.ByteString
        getApiServiceBytes();

    /**
     * <pre>
     * The metric of the violated quota. A quota metric is a named counter to
     * measure usage, such as API requests or CPUs. When an activity occurs in a
     * service, such as Virtual Machine allocation, one or more quota metrics
     * may be affected.
     *
     * For example, "compute.googleapis.com/cpus_per_vm_family",
     * "storage.googleapis.com/internet_egress_bandwidth".
     * </pre>
     *
     * <code>string quota_metric = 4;</code>
     * @return The quotaMetric.
     */
    java.lang.String getQuotaMetric();
    /**
     * <pre>
     * The metric of the violated quota. A quota metric is a named counter to
     * measure usage, such as API requests or CPUs. When an activity occurs in a
     * service, such as Virtual Machine allocation, one or more quota metrics
     * may be affected.
     *
     * For example, "compute.googleapis.com/cpus_per_vm_family",
     * "storage.googleapis.com/internet_egress_bandwidth".
     * </pre>
     *
     * <code>string quota_metric = 4;</code>
     * @return The bytes for quotaMetric.
     */
    com.google.protobuf.ByteString
        getQuotaMetricBytes();

    /**
     * <pre>
     * The id of the violated quota. Also know as "limit name", this is the
     * unique identifier of a quota in the context of an API service.
     *
     * For example, "CPUS-PER-VM-FAMILY-per-project-region".
     * </pre>
     *
     * <code>string quota_id = 5;</code>
     * @return The quotaId.
     */
    java.lang.String getQuotaId();
    /**
     * <pre>
     * The id of the violated quota. Also know as "limit name", this is the
     * unique identifier of a quota in the context of an API service.
     *
     * For example, "CPUS-PER-VM-FAMILY-per-project-region".
     * </pre>
     *
     * <code>string quota_id = 5;</code>
     * @return The bytes for quotaId.
     */
    com.google.protobuf.ByteString
        getQuotaIdBytes();

    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    int getQuotaDimensionsCount();
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    boolean containsQuotaDimensions(
        java.lang.String key);
    /**
     * Use {@link #getQuotaDimensionsMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String>
    getQuotaDimensions();
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    java.util.Map<java.lang.String, java.lang.String>
    getQuotaDimensionsMap();
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    /* nullable */
java.lang.String getQuotaDimensionsOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue);
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    java.lang.String getQuotaDimensionsOrThrow(
        java.lang.String key);

    /**
     * <pre>
     * The enforced quota value at the time of the `QuotaFailure`.
     *
     * For example, if the enforced quota value at the time of the
     * `QuotaFailure` on the number of CPUs is "10", then the value of this
     * field would reflect this quantity.
     * </pre>
     *
     * <code>int64 quota_value = 7;</code>
     * @return The quotaValue.
     */
    long getQuotaValue();

    /**
     * <pre>
     * The new quota value being rolled out at the time of the violation. At the
     * completion of the rollout, this value will be enforced in place of
     * quota_value. If no rollout is in progress at the time of the violation,
     * this field is not set.
     *
     * For example, if at the time of the violation a rollout is in progress
     * changing the number of CPUs quota from 10 to 20, 20 would be the value of
     * this field.
     * </pre>
     *
     * <code>optional int64 future_quota_value = 8;</code>
     * @return Whether the futureQuotaValue field is set.
     */
    boolean hasFutureQuotaValue();
    /**
     * <pre>
     * The new quota value being rolled out at the time of the violation. At the
     * completion of the rollout, this value will be enforced in place of
     * quota_value. If no rollout is in progress at the time of the violation,
     * this field is not set.
     *
     * For example, if at the time of the violation a rollout is in progress
     * changing the number of CPUs quota from 10 to 20, 20 would be the value of
     * this field.
     * </pre>
     *
     * <code>optional int64 future_quota_value = 8;</code>
     * @return The futureQuotaValue.
     */
    long getFutureQuotaValue();
  }
  /**
   * <pre>
   * A message type used to describe a single quota violation.  For example, a
   * daily quota or a custom quota that was exceeded.
   * </pre>
   *
   * Protobuf type {@code google.rpc.QuotaFailure.Violation}
   */
  public static final class Violation extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:google.rpc.QuotaFailure.Violation)
      ViolationOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 4,
        /* suffix= */ "",
        "Violation");
    }
    // Use Violation.newBuilder() to construct.
    private Violation(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Violation() {
      subject_ = "";
      description_ = "";
      apiService_ = "";
      quotaMetric_ = "";
      quotaId_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_Violation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetQuotaDimensions();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_Violation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.QuotaFailure.Violation.class, com.google.rpc.QuotaFailure.Violation.Builder.class);
    }

    private int bitField0_;
    public static final int SUBJECT_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object subject_ = "";
    /**
     * <pre>
     * The subject on which the quota check failed.
     * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
     * developer project id&gt;".
     * </pre>
     *
     * <code>string subject = 1;</code>
     * @return The subject.
     */
    @java.lang.Override
    public java.lang.String getSubject() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subject_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The subject on which the quota check failed.
     * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
     * developer project id&gt;".
     * </pre>
     *
     * <code>string subject = 1;</code>
     * @return The bytes for subject.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSubjectBytes() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        subject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     * <pre>
     * A description of how the quota check failed. Clients can use this
     * description to find more about the quota configuration in the service's
     * public documentation, or find the relevant quota limit to adjust through
     * developer console.
     *
     * For example: "Service disabled" or "Daily Limit for read operations
     * exceeded".
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * A description of how the quota check failed. Clients can use this
     * description to find more about the quota configuration in the service's
     * public documentation, or find the relevant quota limit to adjust through
     * developer console.
     *
     * For example: "Service disabled" or "Daily Limit for read operations
     * exceeded".
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int API_SERVICE_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object apiService_ = "";
    /**
     * <pre>
     * The API Service from which the `QuotaFailure.Violation` orginates. In
     * some cases, Quota issues originate from an API Service other than the one
     * that was called. In other words, a dependency of the called API Service
     * could be the cause of the `QuotaFailure`, and this field would have the
     * dependency API service name.
     *
     * For example, if the called API is Kubernetes Engine API
     * (container.googleapis.com), and a quota violation occurs in the
     * Kubernetes Engine API itself, this field would be
     * "container.googleapis.com". On the other hand, if the quota violation
     * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
     * API (compute.googleapis.com), this field would be
     * "compute.googleapis.com".
     * </pre>
     *
     * <code>string api_service = 3;</code>
     * @return The apiService.
     */
    @java.lang.Override
    public java.lang.String getApiService() {
      java.lang.Object ref = apiService_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiService_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The API Service from which the `QuotaFailure.Violation` orginates. In
     * some cases, Quota issues originate from an API Service other than the one
     * that was called. In other words, a dependency of the called API Service
     * could be the cause of the `QuotaFailure`, and this field would have the
     * dependency API service name.
     *
     * For example, if the called API is Kubernetes Engine API
     * (container.googleapis.com), and a quota violation occurs in the
     * Kubernetes Engine API itself, this field would be
     * "container.googleapis.com". On the other hand, if the quota violation
     * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
     * API (compute.googleapis.com), this field would be
     * "compute.googleapis.com".
     * </pre>
     *
     * <code>string api_service = 3;</code>
     * @return The bytes for apiService.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getApiServiceBytes() {
      java.lang.Object ref = apiService_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        apiService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUOTA_METRIC_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private volatile java.lang.Object quotaMetric_ = "";
    /**
     * <pre>
     * The metric of the violated quota. A quota metric is a named counter to
     * measure usage, such as API requests or CPUs. When an activity occurs in a
     * service, such as Virtual Machine allocation, one or more quota metrics
     * may be affected.
     *
     * For example, "compute.googleapis.com/cpus_per_vm_family",
     * "storage.googleapis.com/internet_egress_bandwidth".
     * </pre>
     *
     * <code>string quota_metric = 4;</code>
     * @return The quotaMetric.
     */
    @java.lang.Override
    public java.lang.String getQuotaMetric() {
      java.lang.Object ref = quotaMetric_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quotaMetric_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The metric of the violated quota. A quota metric is a named counter to
     * measure usage, such as API requests or CPUs. When an activity occurs in a
     * service, such as Virtual Machine allocation, one or more quota metrics
     * may be affected.
     *
     * For example, "compute.googleapis.com/cpus_per_vm_family",
     * "storage.googleapis.com/internet_egress_bandwidth".
     * </pre>
     *
     * <code>string quota_metric = 4;</code>
     * @return The bytes for quotaMetric.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getQuotaMetricBytes() {
      java.lang.Object ref = quotaMetric_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        quotaMetric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUOTA_ID_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private volatile java.lang.Object quotaId_ = "";
    /**
     * <pre>
     * The id of the violated quota. Also know as "limit name", this is the
     * unique identifier of a quota in the context of an API service.
     *
     * For example, "CPUS-PER-VM-FAMILY-per-project-region".
     * </pre>
     *
     * <code>string quota_id = 5;</code>
     * @return The quotaId.
     */
    @java.lang.Override
    public java.lang.String getQuotaId() {
      java.lang.Object ref = quotaId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quotaId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The id of the violated quota. Also know as "limit name", this is the
     * unique identifier of a quota in the context of an API service.
     *
     * For example, "CPUS-PER-VM-FAMILY-per-project-region".
     * </pre>
     *
     * <code>string quota_id = 5;</code>
     * @return The bytes for quotaId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getQuotaIdBytes() {
      java.lang.Object ref = quotaId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        quotaId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUOTA_DIMENSIONS_FIELD_NUMBER = 6;
    private static final class QuotaDimensionsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, java.lang.String> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, java.lang.String>newDefaultInstance(
                  com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_Violation_QuotaDimensionsEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "");
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> quotaDimensions_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetQuotaDimensions() {
      if (quotaDimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            QuotaDimensionsDefaultEntryHolder.defaultEntry);
      }
      return quotaDimensions_;
    }
    public int getQuotaDimensionsCount() {
      return internalGetQuotaDimensions().getMap().size();
    }
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    @java.lang.Override
    public boolean containsQuotaDimensions(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetQuotaDimensions().getMap().containsKey(key);
    }
    /**
     * Use {@link #getQuotaDimensionsMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getQuotaDimensions() {
      return getQuotaDimensionsMap();
    }
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getQuotaDimensionsMap() {
      return internalGetQuotaDimensions().getMap();
    }
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    @java.lang.Override
    public /* nullable */
java.lang.String getQuotaDimensionsOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetQuotaDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * The dimensions of the violated quota. Every non-global quota is enforced
     * on a set of dimensions. While quota metric defines what to count, the
     * dimensions specify for what aspects the counter should be increased.
     *
     * For example, the quota "CPUs per region per VM family" enforces a limit
     * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
     * "region" and "vm_family". And if the violation occurred in region
     * "us-central1" and for VM family "n1", the quota_dimensions would be,
     *
     * {
     * "region": "us-central1",
     * "vm_family": "n1",
     * }
     *
     * When a quota is enforced globally, the quota_dimensions would always be
     * empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getQuotaDimensionsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetQuotaDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int QUOTA_VALUE_FIELD_NUMBER = 7;
    private long quotaValue_ = 0L;
    /**
     * <pre>
     * The enforced quota value at the time of the `QuotaFailure`.
     *
     * For example, if the enforced quota value at the time of the
     * `QuotaFailure` on the number of CPUs is "10", then the value of this
     * field would reflect this quantity.
     * </pre>
     *
     * <code>int64 quota_value = 7;</code>
     * @return The quotaValue.
     */
    @java.lang.Override
    public long getQuotaValue() {
      return quotaValue_;
    }

    public static final int FUTURE_QUOTA_VALUE_FIELD_NUMBER = 8;
    private long futureQuotaValue_ = 0L;
    /**
     * <pre>
     * The new quota value being rolled out at the time of the violation. At the
     * completion of the rollout, this value will be enforced in place of
     * quota_value. If no rollout is in progress at the time of the violation,
     * this field is not set.
     *
     * For example, if at the time of the violation a rollout is in progress
     * changing the number of CPUs quota from 10 to 20, 20 would be the value of
     * this field.
     * </pre>
     *
     * <code>optional int64 future_quota_value = 8;</code>
     * @return Whether the futureQuotaValue field is set.
     */
    @java.lang.Override
    public boolean hasFutureQuotaValue() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The new quota value being rolled out at the time of the violation. At the
     * completion of the rollout, this value will be enforced in place of
     * quota_value. If no rollout is in progress at the time of the violation,
     * this field is not set.
     *
     * For example, if at the time of the violation a rollout is in progress
     * changing the number of CPUs quota from 10 to 20, 20 would be the value of
     * this field.
     * </pre>
     *
     * <code>optional int64 future_quota_value = 8;</code>
     * @return The futureQuotaValue.
     */
    @java.lang.Override
    public long getFutureQuotaValue() {
      return futureQuotaValue_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(subject_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, subject_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, description_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(apiService_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, apiService_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(quotaMetric_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 4, quotaMetric_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(quotaId_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 5, quotaId_);
      }
      com.google.protobuf.GeneratedMessage
        .serializeStringMapTo(
          output,
          internalGetQuotaDimensions(),
          QuotaDimensionsDefaultEntryHolder.defaultEntry,
          6);
      if (quotaValue_ != 0L) {
        output.writeInt64(7, quotaValue_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt64(8, futureQuotaValue_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(subject_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, subject_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, description_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(apiService_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, apiService_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(quotaMetric_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(4, quotaMetric_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(quotaId_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(5, quotaId_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
           : internalGetQuotaDimensions().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
        quotaDimensions__ = QuotaDimensionsDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(6, quotaDimensions__);
      }
      if (quotaValue_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(7, quotaValue_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(8, futureQuotaValue_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.rpc.QuotaFailure.Violation)) {
        return super.equals(obj);
      }
      com.google.rpc.QuotaFailure.Violation other = (com.google.rpc.QuotaFailure.Violation) obj;

      if (!getSubject()
          .equals(other.getSubject())) return false;
      if (!getDescription()
          .equals(other.getDescription())) return false;
      if (!getApiService()
          .equals(other.getApiService())) return false;
      if (!getQuotaMetric()
          .equals(other.getQuotaMetric())) return false;
      if (!getQuotaId()
          .equals(other.getQuotaId())) return false;
      if (!internalGetQuotaDimensions().equals(
          other.internalGetQuotaDimensions())) return false;
      if (getQuotaValue()
          != other.getQuotaValue()) return false;
      if (hasFutureQuotaValue() != other.hasFutureQuotaValue()) return false;
      if (hasFutureQuotaValue()) {
        if (getFutureQuotaValue()
            != other.getFutureQuotaValue()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getSubject().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + API_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getApiService().hashCode();
      hash = (37 * hash) + QUOTA_METRIC_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaMetric().hashCode();
      hash = (37 * hash) + QUOTA_ID_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaId().hashCode();
      if (!internalGetQuotaDimensions().getMap().isEmpty()) {
        hash = (37 * hash) + QUOTA_DIMENSIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetQuotaDimensions().hashCode();
      }
      hash = (37 * hash) + QUOTA_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getQuotaValue());
      if (hasFutureQuotaValue()) {
        hash = (37 * hash) + FUTURE_QUOTA_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getFutureQuotaValue());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.QuotaFailure.Violation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.QuotaFailure.Violation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.google.rpc.QuotaFailure.Violation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.rpc.QuotaFailure.Violation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A message type used to describe a single quota violation.  For example, a
     * daily quota or a custom quota that was exceeded.
     * </pre>
     *
     * Protobuf type {@code google.rpc.QuotaFailure.Violation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.rpc.QuotaFailure.Violation)
        com.google.rpc.QuotaFailure.ViolationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_Violation_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetQuotaDimensions();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetMutableQuotaDimensions();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_Violation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.QuotaFailure.Violation.class, com.google.rpc.QuotaFailure.Violation.Builder.class);
      }

      // Construct using com.google.rpc.QuotaFailure.Violation.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        subject_ = "";
        description_ = "";
        apiService_ = "";
        quotaMetric_ = "";
        quotaId_ = "";
        internalGetMutableQuotaDimensions().clear();
        quotaValue_ = 0L;
        futureQuotaValue_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_Violation_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.QuotaFailure.Violation getDefaultInstanceForType() {
        return com.google.rpc.QuotaFailure.Violation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.QuotaFailure.Violation build() {
        com.google.rpc.QuotaFailure.Violation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.QuotaFailure.Violation buildPartial() {
        com.google.rpc.QuotaFailure.Violation result = new com.google.rpc.QuotaFailure.Violation(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.rpc.QuotaFailure.Violation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.subject_ = subject_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.apiService_ = apiService_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.quotaMetric_ = quotaMetric_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.quotaId_ = quotaId_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.quotaDimensions_ = internalGetQuotaDimensions();
          result.quotaDimensions_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.quotaValue_ = quotaValue_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.futureQuotaValue_ = futureQuotaValue_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.QuotaFailure.Violation) {
          return mergeFrom((com.google.rpc.QuotaFailure.Violation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.QuotaFailure.Violation other) {
        if (other == com.google.rpc.QuotaFailure.Violation.getDefaultInstance()) return this;
        if (!other.getSubject().isEmpty()) {
          subject_ = other.subject_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getApiService().isEmpty()) {
          apiService_ = other.apiService_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getQuotaMetric().isEmpty()) {
          quotaMetric_ = other.quotaMetric_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getQuotaId().isEmpty()) {
          quotaId_ = other.quotaId_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        internalGetMutableQuotaDimensions().mergeFrom(
            other.internalGetQuotaDimensions());
        bitField0_ |= 0x00000020;
        if (other.getQuotaValue() != 0L) {
          setQuotaValue(other.getQuotaValue());
        }
        if (other.hasFutureQuotaValue()) {
          setFutureQuotaValue(other.getFutureQuotaValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                subject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                apiService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                quotaMetric_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                quotaId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
              case 50: {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                quotaDimensions__ = input.readMessage(
                    QuotaDimensionsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableQuotaDimensions().getMutableMap().put(
                    quotaDimensions__.getKey(), quotaDimensions__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              case 56: {
                quotaValue_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
              case 64: {
                futureQuotaValue_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object subject_ = "";
      /**
       * <pre>
       * The subject on which the quota check failed.
       * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
       * developer project id&gt;".
       * </pre>
       *
       * <code>string subject = 1;</code>
       * @return The subject.
       */
      public java.lang.String getSubject() {
        java.lang.Object ref = subject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The subject on which the quota check failed.
       * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
       * developer project id&gt;".
       * </pre>
       *
       * <code>string subject = 1;</code>
       * @return The bytes for subject.
       */
      public com.google.protobuf.ByteString
          getSubjectBytes() {
        java.lang.Object ref = subject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          subject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The subject on which the quota check failed.
       * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
       * developer project id&gt;".
       * </pre>
       *
       * <code>string subject = 1;</code>
       * @param value The subject to set.
       * @return This builder for chaining.
       */
      public Builder setSubject(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        subject_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The subject on which the quota check failed.
       * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
       * developer project id&gt;".
       * </pre>
       *
       * <code>string subject = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearSubject() {
        subject_ = getDefaultInstance().getSubject();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The subject on which the quota check failed.
       * For example, "clientip:&lt;ip address of client&gt;" or "project:&lt;Google
       * developer project id&gt;".
       * </pre>
       *
       * <code>string subject = 1;</code>
       * @param value The bytes for subject to set.
       * @return This builder for chaining.
       */
      public Builder setSubjectBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        subject_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <pre>
       * A description of how the quota check failed. Clients can use this
       * description to find more about the quota configuration in the service's
       * public documentation, or find the relevant quota limit to adjust through
       * developer console.
       *
       * For example: "Service disabled" or "Daily Limit for read operations
       * exceeded".
       * </pre>
       *
       * <code>string description = 2;</code>
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * A description of how the quota check failed. Clients can use this
       * description to find more about the quota configuration in the service's
       * public documentation, or find the relevant quota limit to adjust through
       * developer console.
       *
       * For example: "Service disabled" or "Daily Limit for read operations
       * exceeded".
       * </pre>
       *
       * <code>string description = 2;</code>
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * A description of how the quota check failed. Clients can use this
       * description to find more about the quota configuration in the service's
       * public documentation, or find the relevant quota limit to adjust through
       * developer console.
       *
       * For example: "Service disabled" or "Daily Limit for read operations
       * exceeded".
       * </pre>
       *
       * <code>string description = 2;</code>
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A description of how the quota check failed. Clients can use this
       * description to find more about the quota configuration in the service's
       * public documentation, or find the relevant quota limit to adjust through
       * developer console.
       *
       * For example: "Service disabled" or "Daily Limit for read operations
       * exceeded".
       * </pre>
       *
       * <code>string description = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A description of how the quota check failed. Clients can use this
       * description to find more about the quota configuration in the service's
       * public documentation, or find the relevant quota limit to adjust through
       * developer console.
       *
       * For example: "Service disabled" or "Daily Limit for read operations
       * exceeded".
       * </pre>
       *
       * <code>string description = 2;</code>
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object apiService_ = "";
      /**
       * <pre>
       * The API Service from which the `QuotaFailure.Violation` orginates. In
       * some cases, Quota issues originate from an API Service other than the one
       * that was called. In other words, a dependency of the called API Service
       * could be the cause of the `QuotaFailure`, and this field would have the
       * dependency API service name.
       *
       * For example, if the called API is Kubernetes Engine API
       * (container.googleapis.com), and a quota violation occurs in the
       * Kubernetes Engine API itself, this field would be
       * "container.googleapis.com". On the other hand, if the quota violation
       * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
       * API (compute.googleapis.com), this field would be
       * "compute.googleapis.com".
       * </pre>
       *
       * <code>string api_service = 3;</code>
       * @return The apiService.
       */
      public java.lang.String getApiService() {
        java.lang.Object ref = apiService_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          apiService_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The API Service from which the `QuotaFailure.Violation` orginates. In
       * some cases, Quota issues originate from an API Service other than the one
       * that was called. In other words, a dependency of the called API Service
       * could be the cause of the `QuotaFailure`, and this field would have the
       * dependency API service name.
       *
       * For example, if the called API is Kubernetes Engine API
       * (container.googleapis.com), and a quota violation occurs in the
       * Kubernetes Engine API itself, this field would be
       * "container.googleapis.com". On the other hand, if the quota violation
       * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
       * API (compute.googleapis.com), this field would be
       * "compute.googleapis.com".
       * </pre>
       *
       * <code>string api_service = 3;</code>
       * @return The bytes for apiService.
       */
      public com.google.protobuf.ByteString
          getApiServiceBytes() {
        java.lang.Object ref = apiService_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          apiService_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The API Service from which the `QuotaFailure.Violation` orginates. In
       * some cases, Quota issues originate from an API Service other than the one
       * that was called. In other words, a dependency of the called API Service
       * could be the cause of the `QuotaFailure`, and this field would have the
       * dependency API service name.
       *
       * For example, if the called API is Kubernetes Engine API
       * (container.googleapis.com), and a quota violation occurs in the
       * Kubernetes Engine API itself, this field would be
       * "container.googleapis.com". On the other hand, if the quota violation
       * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
       * API (compute.googleapis.com), this field would be
       * "compute.googleapis.com".
       * </pre>
       *
       * <code>string api_service = 3;</code>
       * @param value The apiService to set.
       * @return This builder for chaining.
       */
      public Builder setApiService(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        apiService_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The API Service from which the `QuotaFailure.Violation` orginates. In
       * some cases, Quota issues originate from an API Service other than the one
       * that was called. In other words, a dependency of the called API Service
       * could be the cause of the `QuotaFailure`, and this field would have the
       * dependency API service name.
       *
       * For example, if the called API is Kubernetes Engine API
       * (container.googleapis.com), and a quota violation occurs in the
       * Kubernetes Engine API itself, this field would be
       * "container.googleapis.com". On the other hand, if the quota violation
       * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
       * API (compute.googleapis.com), this field would be
       * "compute.googleapis.com".
       * </pre>
       *
       * <code>string api_service = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearApiService() {
        apiService_ = getDefaultInstance().getApiService();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The API Service from which the `QuotaFailure.Violation` orginates. In
       * some cases, Quota issues originate from an API Service other than the one
       * that was called. In other words, a dependency of the called API Service
       * could be the cause of the `QuotaFailure`, and this field would have the
       * dependency API service name.
       *
       * For example, if the called API is Kubernetes Engine API
       * (container.googleapis.com), and a quota violation occurs in the
       * Kubernetes Engine API itself, this field would be
       * "container.googleapis.com". On the other hand, if the quota violation
       * occurs when the Kubernetes Engine API creates VMs in the Compute Engine
       * API (compute.googleapis.com), this field would be
       * "compute.googleapis.com".
       * </pre>
       *
       * <code>string api_service = 3;</code>
       * @param value The bytes for apiService to set.
       * @return This builder for chaining.
       */
      public Builder setApiServiceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        apiService_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object quotaMetric_ = "";
      /**
       * <pre>
       * The metric of the violated quota. A quota metric is a named counter to
       * measure usage, such as API requests or CPUs. When an activity occurs in a
       * service, such as Virtual Machine allocation, one or more quota metrics
       * may be affected.
       *
       * For example, "compute.googleapis.com/cpus_per_vm_family",
       * "storage.googleapis.com/internet_egress_bandwidth".
       * </pre>
       *
       * <code>string quota_metric = 4;</code>
       * @return The quotaMetric.
       */
      public java.lang.String getQuotaMetric() {
        java.lang.Object ref = quotaMetric_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          quotaMetric_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The metric of the violated quota. A quota metric is a named counter to
       * measure usage, such as API requests or CPUs. When an activity occurs in a
       * service, such as Virtual Machine allocation, one or more quota metrics
       * may be affected.
       *
       * For example, "compute.googleapis.com/cpus_per_vm_family",
       * "storage.googleapis.com/internet_egress_bandwidth".
       * </pre>
       *
       * <code>string quota_metric = 4;</code>
       * @return The bytes for quotaMetric.
       */
      public com.google.protobuf.ByteString
          getQuotaMetricBytes() {
        java.lang.Object ref = quotaMetric_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          quotaMetric_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The metric of the violated quota. A quota metric is a named counter to
       * measure usage, such as API requests or CPUs. When an activity occurs in a
       * service, such as Virtual Machine allocation, one or more quota metrics
       * may be affected.
       *
       * For example, "compute.googleapis.com/cpus_per_vm_family",
       * "storage.googleapis.com/internet_egress_bandwidth".
       * </pre>
       *
       * <code>string quota_metric = 4;</code>
       * @param value The quotaMetric to set.
       * @return This builder for chaining.
       */
      public Builder setQuotaMetric(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        quotaMetric_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The metric of the violated quota. A quota metric is a named counter to
       * measure usage, such as API requests or CPUs. When an activity occurs in a
       * service, such as Virtual Machine allocation, one or more quota metrics
       * may be affected.
       *
       * For example, "compute.googleapis.com/cpus_per_vm_family",
       * "storage.googleapis.com/internet_egress_bandwidth".
       * </pre>
       *
       * <code>string quota_metric = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearQuotaMetric() {
        quotaMetric_ = getDefaultInstance().getQuotaMetric();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The metric of the violated quota. A quota metric is a named counter to
       * measure usage, such as API requests or CPUs. When an activity occurs in a
       * service, such as Virtual Machine allocation, one or more quota metrics
       * may be affected.
       *
       * For example, "compute.googleapis.com/cpus_per_vm_family",
       * "storage.googleapis.com/internet_egress_bandwidth".
       * </pre>
       *
       * <code>string quota_metric = 4;</code>
       * @param value The bytes for quotaMetric to set.
       * @return This builder for chaining.
       */
      public Builder setQuotaMetricBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        quotaMetric_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object quotaId_ = "";
      /**
       * <pre>
       * The id of the violated quota. Also know as "limit name", this is the
       * unique identifier of a quota in the context of an API service.
       *
       * For example, "CPUS-PER-VM-FAMILY-per-project-region".
       * </pre>
       *
       * <code>string quota_id = 5;</code>
       * @return The quotaId.
       */
      public java.lang.String getQuotaId() {
        java.lang.Object ref = quotaId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          quotaId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The id of the violated quota. Also know as "limit name", this is the
       * unique identifier of a quota in the context of an API service.
       *
       * For example, "CPUS-PER-VM-FAMILY-per-project-region".
       * </pre>
       *
       * <code>string quota_id = 5;</code>
       * @return The bytes for quotaId.
       */
      public com.google.protobuf.ByteString
          getQuotaIdBytes() {
        java.lang.Object ref = quotaId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          quotaId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The id of the violated quota. Also know as "limit name", this is the
       * unique identifier of a quota in the context of an API service.
       *
       * For example, "CPUS-PER-VM-FAMILY-per-project-region".
       * </pre>
       *
       * <code>string quota_id = 5;</code>
       * @param value The quotaId to set.
       * @return This builder for chaining.
       */
      public Builder setQuotaId(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        quotaId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The id of the violated quota. Also know as "limit name", this is the
       * unique identifier of a quota in the context of an API service.
       *
       * For example, "CPUS-PER-VM-FAMILY-per-project-region".
       * </pre>
       *
       * <code>string quota_id = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearQuotaId() {
        quotaId_ = getDefaultInstance().getQuotaId();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The id of the violated quota. Also know as "limit name", this is the
       * unique identifier of a quota in the context of an API service.
       *
       * For example, "CPUS-PER-VM-FAMILY-per-project-region".
       * </pre>
       *
       * <code>string quota_id = 5;</code>
       * @param value The bytes for quotaId to set.
       * @return This builder for chaining.
       */
      public Builder setQuotaIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        quotaId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
          java.lang.String, java.lang.String> quotaDimensions_;
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetQuotaDimensions() {
        if (quotaDimensions_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              QuotaDimensionsDefaultEntryHolder.defaultEntry);
        }
        return quotaDimensions_;
      }
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableQuotaDimensions() {
        if (quotaDimensions_ == null) {
          quotaDimensions_ = com.google.protobuf.MapField.newMapField(
              QuotaDimensionsDefaultEntryHolder.defaultEntry);
        }
        if (!quotaDimensions_.isMutable()) {
          quotaDimensions_ = quotaDimensions_.copy();
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return quotaDimensions_;
      }
      public int getQuotaDimensionsCount() {
        return internalGetQuotaDimensions().getMap().size();
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      @java.lang.Override
      public boolean containsQuotaDimensions(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetQuotaDimensions().getMap().containsKey(key);
      }
      /**
       * Use {@link #getQuotaDimensionsMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getQuotaDimensions() {
        return getQuotaDimensionsMap();
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getQuotaDimensionsMap() {
        return internalGetQuotaDimensions().getMap();
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      @java.lang.Override
      public /* nullable */
java.lang.String getQuotaDimensionsOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetQuotaDimensions().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getQuotaDimensionsOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetQuotaDimensions().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }
      public Builder clearQuotaDimensions() {
        bitField0_ = (bitField0_ & ~0x00000020);
        internalGetMutableQuotaDimensions().getMutableMap()
            .clear();
        return this;
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      public Builder removeQuotaDimensions(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        internalGetMutableQuotaDimensions().getMutableMap()
            .remove(key);
        return this;
      }
      /**
       * Use alternate mutation accessors instead.
       */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String>
          getMutableQuotaDimensions() {
        bitField0_ |= 0x00000020;
        return internalGetMutableQuotaDimensions().getMutableMap();
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      public Builder putQuotaDimensions(
          java.lang.String key,
          java.lang.String value) {
        if (key == null) { throw new NullPointerException("map key"); }
        if (value == null) { throw new NullPointerException("map value"); }
        internalGetMutableQuotaDimensions().getMutableMap()
            .put(key, value);
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * The dimensions of the violated quota. Every non-global quota is enforced
       * on a set of dimensions. While quota metric defines what to count, the
       * dimensions specify for what aspects the counter should be increased.
       *
       * For example, the quota "CPUs per region per VM family" enforces a limit
       * on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
       * "region" and "vm_family". And if the violation occurred in region
       * "us-central1" and for VM family "n1", the quota_dimensions would be,
       *
       * {
       * "region": "us-central1",
       * "vm_family": "n1",
       * }
       *
       * When a quota is enforced globally, the quota_dimensions would always be
       * empty.
       * </pre>
       *
       * <code>map&lt;string, string&gt; quota_dimensions = 6;</code>
       */
      public Builder putAllQuotaDimensions(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableQuotaDimensions().getMutableMap()
            .putAll(values);
        bitField0_ |= 0x00000020;
        return this;
      }

      private long quotaValue_ ;
      /**
       * <pre>
       * The enforced quota value at the time of the `QuotaFailure`.
       *
       * For example, if the enforced quota value at the time of the
       * `QuotaFailure` on the number of CPUs is "10", then the value of this
       * field would reflect this quantity.
       * </pre>
       *
       * <code>int64 quota_value = 7;</code>
       * @return The quotaValue.
       */
      @java.lang.Override
      public long getQuotaValue() {
        return quotaValue_;
      }
      /**
       * <pre>
       * The enforced quota value at the time of the `QuotaFailure`.
       *
       * For example, if the enforced quota value at the time of the
       * `QuotaFailure` on the number of CPUs is "10", then the value of this
       * field would reflect this quantity.
       * </pre>
       *
       * <code>int64 quota_value = 7;</code>
       * @param value The quotaValue to set.
       * @return This builder for chaining.
       */
      public Builder setQuotaValue(long value) {

        quotaValue_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The enforced quota value at the time of the `QuotaFailure`.
       *
       * For example, if the enforced quota value at the time of the
       * `QuotaFailure` on the number of CPUs is "10", then the value of this
       * field would reflect this quantity.
       * </pre>
       *
       * <code>int64 quota_value = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearQuotaValue() {
        bitField0_ = (bitField0_ & ~0x00000040);
        quotaValue_ = 0L;
        onChanged();
        return this;
      }

      private long futureQuotaValue_ ;
      /**
       * <pre>
       * The new quota value being rolled out at the time of the violation. At the
       * completion of the rollout, this value will be enforced in place of
       * quota_value. If no rollout is in progress at the time of the violation,
       * this field is not set.
       *
       * For example, if at the time of the violation a rollout is in progress
       * changing the number of CPUs quota from 10 to 20, 20 would be the value of
       * this field.
       * </pre>
       *
       * <code>optional int64 future_quota_value = 8;</code>
       * @return Whether the futureQuotaValue field is set.
       */
      @java.lang.Override
      public boolean hasFutureQuotaValue() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * The new quota value being rolled out at the time of the violation. At the
       * completion of the rollout, this value will be enforced in place of
       * quota_value. If no rollout is in progress at the time of the violation,
       * this field is not set.
       *
       * For example, if at the time of the violation a rollout is in progress
       * changing the number of CPUs quota from 10 to 20, 20 would be the value of
       * this field.
       * </pre>
       *
       * <code>optional int64 future_quota_value = 8;</code>
       * @return The futureQuotaValue.
       */
      @java.lang.Override
      public long getFutureQuotaValue() {
        return futureQuotaValue_;
      }
      /**
       * <pre>
       * The new quota value being rolled out at the time of the violation. At the
       * completion of the rollout, this value will be enforced in place of
       * quota_value. If no rollout is in progress at the time of the violation,
       * this field is not set.
       *
       * For example, if at the time of the violation a rollout is in progress
       * changing the number of CPUs quota from 10 to 20, 20 would be the value of
       * this field.
       * </pre>
       *
       * <code>optional int64 future_quota_value = 8;</code>
       * @param value The futureQuotaValue to set.
       * @return This builder for chaining.
       */
      public Builder setFutureQuotaValue(long value) {

        futureQuotaValue_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The new quota value being rolled out at the time of the violation. At the
       * completion of the rollout, this value will be enforced in place of
       * quota_value. If no rollout is in progress at the time of the violation,
       * this field is not set.
       *
       * For example, if at the time of the violation a rollout is in progress
       * changing the number of CPUs quota from 10 to 20, 20 would be the value of
       * this field.
       * </pre>
       *
       * <code>optional int64 future_quota_value = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearFutureQuotaValue() {
        bitField0_ = (bitField0_ & ~0x00000080);
        futureQuotaValue_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.QuotaFailure.Violation)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.QuotaFailure.Violation)
    private static final com.google.rpc.QuotaFailure.Violation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.rpc.QuotaFailure.Violation();
    }

    public static com.google.rpc.QuotaFailure.Violation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Violation>
        PARSER = new com.google.protobuf.AbstractParser<Violation>() {
      @java.lang.Override
      public Violation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Violation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Violation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.QuotaFailure.Violation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int VIOLATIONS_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.QuotaFailure.Violation> violations_;
  /**
   * <pre>
   * Describes all quota violations.
   * </pre>
   *
   * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.QuotaFailure.Violation> getViolationsList() {
    return violations_;
  }
  /**
   * <pre>
   * Describes all quota violations.
   * </pre>
   *
   * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.QuotaFailure.ViolationOrBuilder> 
      getViolationsOrBuilderList() {
    return violations_;
  }
  /**
   * <pre>
   * Describes all quota violations.
   * </pre>
   *
   * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
   */
  @java.lang.Override
  public int getViolationsCount() {
    return violations_.size();
  }
  /**
   * <pre>
   * Describes all quota violations.
   * </pre>
   *
   * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.QuotaFailure.Violation getViolations(int index) {
    return violations_.get(index);
  }
  /**
   * <pre>
   * Describes all quota violations.
   * </pre>
   *
   * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.QuotaFailure.ViolationOrBuilder getViolationsOrBuilder(
      int index) {
    return violations_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < violations_.size(); i++) {
      output.writeMessage(1, violations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < violations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, violations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.rpc.QuotaFailure)) {
      return super.equals(obj);
    }
    com.google.rpc.QuotaFailure other = (com.google.rpc.QuotaFailure) obj;

    if (!getViolationsList()
        .equals(other.getViolationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getViolationsCount() > 0) {
      hash = (37 * hash) + VIOLATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getViolationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.rpc.QuotaFailure parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.rpc.QuotaFailure parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.rpc.QuotaFailure parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.QuotaFailure parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.rpc.QuotaFailure parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.rpc.QuotaFailure parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.rpc.QuotaFailure prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Describes how a quota check failed.
   *
   * For example if a daily limit was exceeded for the calling project,
   * a service could respond with a QuotaFailure detail containing the project
   * id and the description of the quota limit that was exceeded.  If the
   * calling project hasn't enabled the service in the developer console, then
   * a service could respond with the project id and set `service_disabled`
   * to true.
   *
   * Also see RetryInfo and Help types for other details about handling a
   * quota failure.
   * </pre>
   *
   * Protobuf type {@code google.rpc.QuotaFailure}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.rpc.QuotaFailure)
      com.google.rpc.QuotaFailureOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.QuotaFailure.class, com.google.rpc.QuotaFailure.Builder.class);
    }

    // Construct using com.google.rpc.QuotaFailure.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (violationsBuilder_ == null) {
        violations_ = java.util.Collections.emptyList();
      } else {
        violations_ = null;
        violationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_QuotaFailure_descriptor;
    }

    @java.lang.Override
    public com.google.rpc.QuotaFailure getDefaultInstanceForType() {
      return com.google.rpc.QuotaFailure.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.rpc.QuotaFailure build() {
      com.google.rpc.QuotaFailure result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.rpc.QuotaFailure buildPartial() {
      com.google.rpc.QuotaFailure result = new com.google.rpc.QuotaFailure(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.rpc.QuotaFailure result) {
      if (violationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          violations_ = java.util.Collections.unmodifiableList(violations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.violations_ = violations_;
      } else {
        result.violations_ = violationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.rpc.QuotaFailure result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.rpc.QuotaFailure) {
        return mergeFrom((com.google.rpc.QuotaFailure)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.rpc.QuotaFailure other) {
      if (other == com.google.rpc.QuotaFailure.getDefaultInstance()) return this;
      if (violationsBuilder_ == null) {
        if (!other.violations_.isEmpty()) {
          if (violations_.isEmpty()) {
            violations_ = other.violations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureViolationsIsMutable();
            violations_.addAll(other.violations_);
          }
          onChanged();
        }
      } else {
        if (!other.violations_.isEmpty()) {
          if (violationsBuilder_.isEmpty()) {
            violationsBuilder_.dispose();
            violationsBuilder_ = null;
            violations_ = other.violations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            violationsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 internalGetViolationsFieldBuilder() : null;
          } else {
            violationsBuilder_.addAllMessages(other.violations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.rpc.QuotaFailure.Violation m =
                  input.readMessage(
                      com.google.rpc.QuotaFailure.Violation.parser(),
                      extensionRegistry);
              if (violationsBuilder_ == null) {
                ensureViolationsIsMutable();
                violations_.add(m);
              } else {
                violationsBuilder_.addMessage(m);
              }
              break;
            } // case 10
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.util.List<com.google.rpc.QuotaFailure.Violation> violations_ =
      java.util.Collections.emptyList();
    private void ensureViolationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        violations_ = new java.util.ArrayList<com.google.rpc.QuotaFailure.Violation>(violations_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.rpc.QuotaFailure.Violation, com.google.rpc.QuotaFailure.Violation.Builder, com.google.rpc.QuotaFailure.ViolationOrBuilder> violationsBuilder_;

    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public java.util.List<com.google.rpc.QuotaFailure.Violation> getViolationsList() {
      if (violationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(violations_);
      } else {
        return violationsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public int getViolationsCount() {
      if (violationsBuilder_ == null) {
        return violations_.size();
      } else {
        return violationsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public com.google.rpc.QuotaFailure.Violation getViolations(int index) {
      if (violationsBuilder_ == null) {
        return violations_.get(index);
      } else {
        return violationsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder setViolations(
        int index, com.google.rpc.QuotaFailure.Violation value) {
      if (violationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureViolationsIsMutable();
        violations_.set(index, value);
        onChanged();
      } else {
        violationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder setViolations(
        int index, com.google.rpc.QuotaFailure.Violation.Builder builderForValue) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.set(index, builderForValue.build());
        onChanged();
      } else {
        violationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder addViolations(com.google.rpc.QuotaFailure.Violation value) {
      if (violationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureViolationsIsMutable();
        violations_.add(value);
        onChanged();
      } else {
        violationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder addViolations(
        int index, com.google.rpc.QuotaFailure.Violation value) {
      if (violationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureViolationsIsMutable();
        violations_.add(index, value);
        onChanged();
      } else {
        violationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder addViolations(
        com.google.rpc.QuotaFailure.Violation.Builder builderForValue) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.add(builderForValue.build());
        onChanged();
      } else {
        violationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder addViolations(
        int index, com.google.rpc.QuotaFailure.Violation.Builder builderForValue) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.add(index, builderForValue.build());
        onChanged();
      } else {
        violationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder addAllViolations(
        java.lang.Iterable<? extends com.google.rpc.QuotaFailure.Violation> values) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, violations_);
        onChanged();
      } else {
        violationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder clearViolations() {
      if (violationsBuilder_ == null) {
        violations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        violationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public Builder removeViolations(int index) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.remove(index);
        onChanged();
      } else {
        violationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public com.google.rpc.QuotaFailure.Violation.Builder getViolationsBuilder(
        int index) {
      return internalGetViolationsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public com.google.rpc.QuotaFailure.ViolationOrBuilder getViolationsOrBuilder(
        int index) {
      if (violationsBuilder_ == null) {
        return violations_.get(index);  } else {
        return violationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public java.util.List<? extends com.google.rpc.QuotaFailure.ViolationOrBuilder> 
         getViolationsOrBuilderList() {
      if (violationsBuilder_ != null) {
        return violationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(violations_);
      }
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public com.google.rpc.QuotaFailure.Violation.Builder addViolationsBuilder() {
      return internalGetViolationsFieldBuilder().addBuilder(
          com.google.rpc.QuotaFailure.Violation.getDefaultInstance());
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public com.google.rpc.QuotaFailure.Violation.Builder addViolationsBuilder(
        int index) {
      return internalGetViolationsFieldBuilder().addBuilder(
          index, com.google.rpc.QuotaFailure.Violation.getDefaultInstance());
    }
    /**
     * <pre>
     * Describes all quota violations.
     * </pre>
     *
     * <code>repeated .google.rpc.QuotaFailure.Violation violations = 1;</code>
     */
    public java.util.List<com.google.rpc.QuotaFailure.Violation.Builder> 
         getViolationsBuilderList() {
      return internalGetViolationsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.rpc.QuotaFailure.Violation, com.google.rpc.QuotaFailure.Violation.Builder, com.google.rpc.QuotaFailure.ViolationOrBuilder> 
        internalGetViolationsFieldBuilder() {
      if (violationsBuilder_ == null) {
        violationsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            com.google.rpc.QuotaFailure.Violation, com.google.rpc.QuotaFailure.Violation.Builder, com.google.rpc.QuotaFailure.ViolationOrBuilder>(
                violations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        violations_ = null;
      }
      return violationsBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.rpc.QuotaFailure)
  }

  // @@protoc_insertion_point(class_scope:google.rpc.QuotaFailure)
  private static final com.google.rpc.QuotaFailure DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.rpc.QuotaFailure();
  }

  public static com.google.rpc.QuotaFailure getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaFailure>
      PARSER = new com.google.protobuf.AbstractParser<QuotaFailure>() {
    @java.lang.Override
    public QuotaFailure parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<QuotaFailure> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaFailure> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.rpc.QuotaFailure getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

