/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;

public enum Nullness implements AbstractValue<Nullness>
{
    NULLABLE("Nullable"),
    NULL("Null"),
    NONNULL("Non-null"),
    BOTTOM("Bottom");

    private final String displayName;

    private Nullness(String displayName) {
        this.displayName = displayName;
    }

    public Nullness leastUpperBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == BOTTOM) {
            return other;
        }
        if (other == BOTTOM) {
            return this;
        }
        return NULLABLE;
    }

    public Nullness greatestLowerBound(Nullness other) {
        if (this == other) {
            return this;
        }
        if (this == NULLABLE) {
            return other;
        }
        if (other == NULLABLE) {
            return this;
        }
        return BOTTOM;
    }

    public Nullness deducedValueWhenNotEqual() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 2 -> NULLABLE;
            case 1 -> NONNULL;
            case 3 -> BOTTOM;
        };
    }

    public String toString() {
        return this.displayName;
    }
}

