/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.Processable;
import proguard.util.SimpleProcessable;

public class KotlinFunctionMetadata
extends SimpleProcessable
implements Processable {
    public String name;
    public List<KotlinContractMetadata> contracts;
    public KotlinTypeMetadata receiverType;
    public List<KotlinTypeMetadata> contextReceivers;
    public KotlinTypeMetadata returnType;
    public List<KotlinTypeParameterMetadata> typeParameters;
    public List<KotlinValueParameterMetadata> valueParameters;
    public KotlinVersionRequirementMetadata versionRequirement;
    public KotlinFunctionFlags flags;
    public MethodSignature jvmSignature;
    public Method referencedMethod;
    public Clazz referencedMethodClass;
    public Method referencedDefaultMethod;
    public Clazz referencedDefaultMethodClass;
    public Method referencedDefaultImplementationMethod;
    public Clazz referencedDefaultImplementationMethodClass;
    public String lambdaClassOriginName;
    public Clazz referencedLambdaClassOrigin;

    public KotlinFunctionMetadata(KotlinFunctionFlags flags, String name) {
        this.name = name;
        this.flags = flags;
    }

    public void accept(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionVisitor kotlinFunctionVisitor) {
        kotlinFunctionVisitor.visitFunction(clazz, kotlinDeclarationContainerMetadata, this);
    }

    public void accept(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionVisitor kotlinFunctionVisitor) {
        kotlinFunctionVisitor.visitSyntheticFunction(clazz, kotlinSyntheticClassKindMetadata, this);
    }

    public void valueParametersAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinValueParameterVisitor kotlinValueParameterVisitor) {
        if (this.valueParameters != null) {
            for (KotlinValueParameterMetadata valueParameter : this.valueParameters) {
                valueParameter.accept(clazz, kotlinMetadata, this, kotlinValueParameterVisitor);
            }
        }
    }

    public void typeParametersAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeParameterVisitor kotlinTypeParameterVisitor) {
        if (this.typeParameters != null) {
            for (KotlinTypeParameterMetadata typeParameter : this.typeParameters) {
                typeParameter.accept(clazz, kotlinMetadata, this, kotlinTypeParameterVisitor);
            }
        }
    }

    public void returnTypeAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitFunctionReturnType(clazz, kotlinMetadata, this, this.returnType);
    }

    public void receiverTypeAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.receiverType != null) {
            kotlinTypeVisitor.visitFunctionReceiverType(clazz, kotlinMetadata, this, this.receiverType);
        }
    }

    public void contextReceiverTypesAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.contextReceivers != null) {
            for (KotlinTypeMetadata contextReceiver : this.contextReceivers) {
                kotlinTypeVisitor.visitFunctionContextReceiverType(clazz, kotlinMetadata, this, contextReceiver);
            }
        }
    }

    public void contractsAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinContractVisitor kotlinContractVisitor) {
        if (this.contracts != null) {
            for (KotlinContractMetadata contract : this.contracts) {
                contract.accept(clazz, kotlinMetadata, this, kotlinContractVisitor);
            }
        }
    }

    public void versionRequirementAccept(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinVersionRequirementVisitor kotlinVersionRequirementVisitor) {
        if (this.versionRequirement != null) {
            this.versionRequirement.accept(clazz, kotlinMetadata, this, kotlinVersionRequirementVisitor);
        }
    }

    @Deprecated
    public void referencedMethodAccept(Clazz clazz, MemberVisitor methodVisitor) {
        this.referencedMethodAccept(methodVisitor);
    }

    public void referencedMethodAccept(MemberVisitor methodVisitor) {
        if (this.referencedMethod != null && this.referencedMethodClass != null) {
            this.referencedMethod.accept(this.referencedMethodClass, methodVisitor);
        }
    }

    public void referencedDefaultMethodAccept(MemberVisitor methodVisitor) {
        if (this.referencedDefaultMethod != null && this.referencedDefaultMethodClass != null) {
            this.referencedDefaultMethod.accept(this.referencedDefaultMethodClass, methodVisitor);
        }
    }

    public void referencedDefaultImplementationMethodAccept(MemberVisitor memberVisitor) {
        if (this.referencedDefaultImplementationMethodClass != null && this.referencedDefaultImplementationMethod != null) {
            this.referencedDefaultImplementationMethod.accept(this.referencedDefaultImplementationMethodClass, memberVisitor);
        }
    }

    public String toString() {
        return "Kotlin " + (this.flags.isSynthesized ? "synthesized " : "") + "function(" + this.name + ")";
    }
}

