/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.fixes.ErrorProneEndPosTable;
import com.google.errorprone.refaster.TemplateMatch;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.IOException;

class BlockTemplateMatch
extends TemplateMatch {
    private final ImmutableList<JCTree.JCStatement> statements;

    public BlockTemplateMatch(JCTree.JCBlock block, Unifier unifier, int start, int end) {
        super((JCTree)((List)((JCTree.JCBlock)Preconditions.checkNotNull((Object)block)).getStatements()).get(start), unifier);
        this.statements = ImmutableList.copyOf(((List)block.getStatements()).subList(start, end));
    }

    public ImmutableList<JCTree.JCStatement> getStatements() {
        return this.statements;
    }

    @Override
    public String getRange(JCTree.JCCompilationUnit unit) {
        try {
            CharSequence sequence = unit.getSourceFile().getCharContent(true);
            JCTree firstStatement = (JCTree)this.statements.getFirst();
            JCTree lastStatement = (JCTree)Iterables.getLast(this.statements);
            return sequence.subSequence(firstStatement.getStartPosition(), ErrorProneEndPosTable.getEndPosition((JCTree)lastStatement, (CompilationUnitTree)unit)).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

