/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.primitives.Longs;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.concurrent.TimeUnit;

@BugPattern(summary="This TimeUnit conversion looks buggy: converting from a smaller unit to a larger unit (and passing a constant), converting to/from the same TimeUnit, or converting TimeUnits where the result is statically known to be 0 or 1 are all buggy patterns.", explanation="This checker flags potential problems with TimeUnit conversions: 1) conversions that are statically known to be equal to 0 or 1; 2) conversions that are converting from a given unit back to the same unit; 3) conversions that are converting from a smaller unit to a larger unit and passing a constant value", severity=BugPattern.SeverityLevel.WARNING)
public final class TimeUnitConversionChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onExactClass("java.util.concurrent.TimeUnit").namedAnyOf(new String[]{"toDays", "toHours", "toMinutes", "toSeconds", "toMillis", "toMicros", "toNanos"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiverOfConversion = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiverOfConversion == null) {
            return Description.NO_MATCH;
        }
        Symbol receiverOfConversionSymbol = ASTHelpers.getSymbol((Tree)receiverOfConversion);
        if (receiverOfConversionSymbol == null) {
            return Description.NO_MATCH;
        }
        String timeUnitName = receiverOfConversionSymbol.getSimpleName().toString();
        Optional receiver = Enums.getIfPresent(TimeUnit.class, (String)timeUnitName);
        if (!receiver.isPresent()) {
            return Description.NO_MATCH;
        }
        String methodName = ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString();
        TimeUnit convertTo = TimeUnitConversionChecker.methodNameToTimeUnit(methodName);
        ExpressionTree arg0 = tree.getArguments().getFirst();
        Long constant = Longs.tryParse((String)String.valueOf(state.getSourceForNode((Tree)arg0)));
        if (constant != null) {
            long converted = TimeUnitConversionChecker.invokeConversion((TimeUnit)((Object)receiver.get()), methodName, constant);
            if (converted == 0L || converted == 1L || constant == converted) {
                SuggestedFix fix = TimeUnitConversionChecker.replaceTreeWith(tree, convertTo, converted + "L");
                return this.describeMatch(tree, (Fix)fix);
            }
            if (((TimeUnit)((Object)receiver.get())).compareTo(convertTo) < 0) {
                return this.describeMatch(tree);
            }
        }
        if (((TimeUnit)((Object)receiver.get())).equals((Object)convertTo)) {
            SuggestedFix fix = TimeUnitConversionChecker.replaceTreeWith(tree, convertTo, state.getSourceForNode((Tree)arg0));
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix replaceTreeWith(MethodInvocationTree tree, TimeUnit units, String replacement) {
        return SuggestedFix.builder().postfixWith((Tree)tree, " /* " + units.toString().toLowerCase() + " */").replace((Tree)tree, replacement).build();
    }

    private static long invokeConversion(TimeUnit timeUnit, String methodName, long duration) {
        return switch (methodName) {
            case "toDays" -> timeUnit.toDays(duration);
            case "toHours" -> timeUnit.toHours(duration);
            case "toMinutes" -> timeUnit.toMinutes(duration);
            case "toSeconds" -> timeUnit.toSeconds(duration);
            case "toMillis" -> timeUnit.toMillis(duration);
            case "toMicros" -> timeUnit.toMicros(duration);
            case "toNanos" -> timeUnit.toNanos(duration);
            default -> throw new IllegalArgumentException();
        };
    }

    private static TimeUnit methodNameToTimeUnit(String methodName) {
        return switch (methodName) {
            case "toDays" -> TimeUnit.DAYS;
            case "toHours" -> TimeUnit.HOURS;
            case "toMinutes" -> TimeUnit.MINUTES;
            case "toSeconds" -> TimeUnit.SECONDS;
            case "toMillis" -> TimeUnit.MILLISECONDS;
            case "toMicros" -> TimeUnit.MICROSECONDS;
            case "toNanos" -> TimeUnit.NANOSECONDS;
            default -> throw new IllegalArgumentException();
        };
    }
}

