/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.auto.value.AutoBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.overloading.AutoBuilder_ParameterOrderingViolation_Builder;
import com.google.errorprone.bugpatterns.overloading.ParameterTree;
import com.sun.source.tree.MethodTree;
import java.util.stream.Collectors;

record ParameterOrderingViolation(MethodTree methodTree, ImmutableList<ParameterTree> actual, ImmutableList<ParameterTree> expected) {
    static Builder builder() {
        return new AutoBuilder_ParameterOrderingViolation_Builder();
    }

    public String getDescription() {
        return "The parameters of this method are inconsistent with other overloaded versions. A consistent order would be: " + this.getSuggestedSignature();
    }

    private String getSuggestedSignature() {
        return String.format("%s(%s)", this.methodTree().getName(), this.getSuggestedParameters());
    }

    private String getSuggestedParameters() {
        return this.expected().stream().map(ParameterTree::toString).collect(Collectors.joining(", "));
    }

    @AutoBuilder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setMethodTree(MethodTree var1);

        abstract Builder setActual(ImmutableList<ParameterTree> var1);

        abstract Builder setExpected(ImmutableList<ParameterTree> var1);

        abstract ParameterOrderingViolation autoBuild();

        public ParameterOrderingViolation build() {
            int expectedParameterCount;
            ParameterOrderingViolation orderingViolation = this.autoBuild();
            int actualParametersCount = orderingViolation.actual().size();
            Preconditions.checkState((actualParametersCount == (expectedParameterCount = orderingViolation.expected().size()) ? 1 : 0) != 0);
            return orderingViolation;
        }
    }
}

