/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;

@BugPattern(summary="This type use has conflicting nullness annotations", severity=BugPattern.SeverityLevel.WARNING)
public class MultipleNullnessAnnotations
extends BugChecker
implements BugChecker.AnnotatedTypeTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchAnnotatedType(AnnotatedTypeTree tree, VisitorState state) {
        return this.match(tree, ASTHelpers.getType((Tree)tree).getAnnotationMirrors());
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        return this.match(tree, sym, sym.getReturnType());
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        return this.match(tree, sym, (Type)sym.asType());
    }

    private Description match(Tree tree, Symbol symbol, Type type) {
        if (type == null) {
            return Description.NO_MATCH;
        }
        return this.match(tree, (Collection<? extends AnnotationMirror>)ImmutableSet.builder().addAll((Iterable)symbol.getAnnotationMirrors()).addAll((Iterable)type.getAnnotationMirrors()).build());
    }

    private Description match(Tree tree, Collection<? extends AnnotationMirror> annotations) {
        if (!NullnessAnnotations.annotationsAreAmbiguous(annotations)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(NullnessAnnotations.annotationsRelevantToNullness(annotations).stream().map(a -> a.getAnnotationType().asElement().toString()).collect(Collectors.joining(", ", "This type use has conflicting nullness annotations: ", ""))).build();
    }
}

