/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Injected constructors cannot be optional nor have binding annotations", severity=BugPattern.SeverityLevel.WARNING)
public class InjectedConstructorAnnotations
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> OPTIONAL_INJECTION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.inject.Inject"), Matchers.hasArgumentWithValue((String)"optional", (Matcher)Matchers.booleanLiteral((boolean)true))});
    private static final Matcher<AnnotationTree> BINDING_ANNOTATION_MATCHER = new Matcher<AnnotationTree>(){

        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            return Matchers.symbolHasAnnotation((String)"com.google.inject.BindingAnnotation").matches(annotationTree.getAnnotationType(), state);
        }
    };

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (InjectedConstructorAnnotations.isInjectedConstructor(methodTree, state)) {
            for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
                if (OPTIONAL_INJECTION_MATCHER.matches((Tree)annotationTree, state)) {
                    fix.replace((Tree)annotationTree, "@Inject");
                    continue;
                }
                if (!BINDING_ANNOTATION_MATCHER.matches((Tree)annotationTree, state)) continue;
                fix.delete((Tree)annotationTree);
            }
        }
        return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(methodTree, (Fix)fix.build());
    }

    private static boolean isInjectedConstructor(MethodTree methodTree, VisitorState state) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.hasAnnotation((String)"com.google.inject.Inject")}).matches((Tree)methodTree, state);
    }
}

