/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.regex.Pattern;

public final class LenientFormatStringUtils {
    private static final ImmutableList<LenientFormatMethod> LENIENT_FORMATTING_METHODS = ImmutableList.of((Object)new LenientFormatMethod((Matcher<ExpressionTree>)Matchers.staticMethod().onClass("com.google.common.base.Preconditions").withNameMatching(Pattern.compile("^check(?!ElementIndex|PositionIndex).*")), 1), (Object)new LenientFormatMethod((Matcher<ExpressionTree>)Matchers.staticMethod().onClass("com.google.common.base.Verify").withNameMatching(Pattern.compile("^verify.*")), 1), (Object)new LenientFormatMethod((Matcher<ExpressionTree>)Matchers.staticMethod().onClass("com.google.common.base.Strings").named("lenientFormat"), 0), (Object)new LenientFormatMethod((Matcher<ExpressionTree>)Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertWithMessage"), 0), (Object)new LenientFormatMethod((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("check"), 0), (Object)new LenientFormatMethod((Matcher<ExpressionTree>)Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("withMessage"), 0));

    public static int getLenientFormatStringPosition(ExpressionTree tree, VisitorState state) {
        for (LenientFormatMethod method : LENIENT_FORMATTING_METHODS) {
            MethodInvocationTree methodInvocation;
            if (!method.matcher().matches((Tree)tree, state) || !(tree instanceof MethodInvocationTree) || method.formatStringPosition >= (methodInvocation = (MethodInvocationTree)tree).getArguments().size()) continue;
            return method.formatStringPosition;
        }
        return -1;
    }

    private LenientFormatStringUtils() {
    }

    private record LenientFormatMethod(Matcher<ExpressionTree> matcher, int formatStringPosition) {
    }
}

