/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="per() methods are no-ops unless combined with atMostEvery(), every(), or onAverageEvery()", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerPerWithoutRateLimit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOG_METHOD = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    private static final Matcher<ExpressionTree> PER_METHOD = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("per");
    private static final Matcher<ExpressionTree> RATE_LIMITING_METHOD = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").namedAnyOf(new String[]{"atMostEvery", "every", "onAverageEvery"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!LOG_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree perNode = null;
        ExpressionTree receiver = tree;
        while (receiver instanceof MethodInvocationTree) {
            if (RATE_LIMITING_METHOD.matches((Tree)receiver, state)) {
                return Description.NO_MATCH;
            }
            if (PER_METHOD.matches((Tree)receiver, state)) {
                perNode = receiver;
            }
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        if (perNode != null) {
            return this.describeMatch(perNode);
        }
        return Description.NO_MATCH;
    }
}

