/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.io.MoreFiles;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.Api;
import com.google.errorprone.bugpatterns.checkreturnvalue.ApiFactory;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.Rules;
import com.google.errorprone.suppliers.Supplier;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;

public final class ExternalCanIgnoreReturnValue
extends Rules.ErrorProneMethodRule {
    private static final String EXTERNAL_API_EXCLUSION_LIST = "CheckReturnValue:ApiExclusionList";
    private static final String EXCLUSION_LIST_PARSER = "CheckReturnValue:ApiExclusionListParser";
    private static final Supplier<MethodPredicate> EXTERNAL_RULE_EVALUATOR = VisitorState.memoize((Supplier & Serializable)state -> state.errorProneOptions().getFlags().get(EXTERNAL_API_EXCLUSION_LIST).filter(s -> !s.isEmpty()).map(filename -> ExternalCanIgnoreReturnValue.loadConfigListFromFile(filename, state.errorProneOptions().getFlags().getEnum(EXCLUSION_LIST_PARSER, ConfigParser.class).orElse(ConfigParser.AS_STRINGS))).orElse((m, s) -> false));

    public static ResultUseRule<VisitorState, Symbol> externalIgnoreList() {
        return new ExternalCanIgnoreReturnValue();
    }

    private ExternalCanIgnoreReturnValue() {
    }

    @Override
    public String id() {
        return "EXTERNAL_API_EXCLUSION_LIST";
    }

    @Override
    public Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol method, VisitorState state) {
        return ((MethodPredicate)EXTERNAL_RULE_EVALUATOR.get(state)).methodMatches(method, state) ? Optional.of(ResultUsePolicy.UNSPECIFIED) : Optional.empty();
    }

    static MethodPredicate loadConfigListFromFile(String filename, ConfigParser configParser) {
        try {
            return configParser.load(filename);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not load external resource for CanIgnoreReturnValue", e);
        }
    }

    private static MethodPredicate configByInterpretingMethodsAsStrings(CharSource file) throws IOException {
        ImmutableSet apis;
        try (Stream lines = file.lines();){
            apis = (ImmutableSet)lines.collect(ImmutableSet.toImmutableSet());
        }
        return new MethodPredicate(){

            @Override
            public boolean methodMatches(Symbol.MethodSymbol methodSymbol, VisitorState state) {
                return apis.contains((Object)this.apiSignature(methodSymbol, state.getTypes()));
            }

            private String apiSignature(Symbol.MethodSymbol methodSymbol, Types types) {
                return String.valueOf(methodSymbol.owner.getQualifiedName()) + "#" + ExternalCanIgnoreReturnValue.methodNameAndParams(methodSymbol, types);
            }
        };
    }

    private static MethodPredicate configByParsingApiObjects(CharSource file) throws IOException {
        ImmutableSetMultimap apis;
        try (Stream lines = file.lines();){
            apis = (ImmutableSetMultimap)lines.map(Api::parse).collect(ImmutableSetMultimap.toImmutableSetMultimap(Api::className, api -> api));
        }
        return (methodSymbol, state) -> apis.get((Object)ExternalCanIgnoreReturnValue.surroundingClass(methodSymbol)).stream().anyMatch(api -> ((Name)methodSymbol.getSimpleName()).contentEquals(api.methodName()) && ExternalCanIgnoreReturnValue.methodParametersMatch(api.parameterTypes(), methodSymbol.params(), state.getTypes()));
    }

    public static String surroundingClass(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol.enclClass().getQualifiedName().toString();
    }

    public static String methodNameAndParams(Symbol.MethodSymbol methodSymbol, Types types) {
        return String.valueOf(methodSymbol.name) + "(" + ExternalCanIgnoreReturnValue.paramsString(types, methodSymbol.params()) + ")";
    }

    private static boolean methodParametersMatch(ImmutableList<String> parameters, List<Symbol.VarSymbol> methodParams, Types types) {
        return Iterables.elementsEqual(parameters, (Iterable)Iterables.transform(methodParams, p -> ApiFactory.fullyErasedAndUnannotatedType(p.type, types)));
    }

    private static String paramsString(Types types, List<Symbol.VarSymbol> params) {
        if (params.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", Iterables.transform(params, p -> ApiFactory.fullyErasedAndUnannotatedType(p.type, types)));
    }

    @FunctionalInterface
    static interface MethodPredicate {
        public boolean methodMatches(Symbol.MethodSymbol var1, VisitorState var2);
    }

    static enum ConfigParser {
        AS_STRINGS{

            @Override
            MethodPredicate load(String file) throws IOException {
                return ExternalCanIgnoreReturnValue.configByInterpretingMethodsAsStrings(MoreFiles.asCharSource((Path)Paths.get(file, new String[0]), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]));
            }
        }
        ,
        PARSE_TOKENS{

            @Override
            MethodPredicate load(String file) throws IOException {
                return ExternalCanIgnoreReturnValue.configByParsingApiObjects(MoreFiles.asCharSource((Path)Paths.get(file, new String[0]), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]));
            }
        };


        abstract MethodPredicate load(String var1) throws IOException;
    }
}

