/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import org.jspecify.annotations.Nullable;

record InvocationInfo(Tree tree, Symbol.MethodSymbol symbol, ImmutableList<Tree> actualParameters, ImmutableList<Symbol.VarSymbol> formalParameters, VisitorState state) {
    static InvocationInfo createFromMethodInvocation(MethodInvocationTree tree, Symbol.MethodSymbol symbol, VisitorState state) {
        return new InvocationInfo(tree, symbol, (ImmutableList<Tree>)ImmutableList.copyOf(tree.getArguments()), InvocationInfo.getFormalParametersWithoutVarArgs(symbol), state);
    }

    static InvocationInfo createFromNewClass(NewClassTree tree, Symbol.MethodSymbol symbol, VisitorState state) {
        return new InvocationInfo(tree, symbol, (ImmutableList<Tree>)ImmutableList.copyOf(tree.getArguments()), InvocationInfo.getFormalParametersWithoutVarArgs(symbol), state);
    }

    static @Nullable InvocationInfo createFromDeconstructionPattern(DeconstructionPatternTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree.getDeconstructor());
        if (!(symbol instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Symbol.ClassSymbol cs = (Symbol.ClassSymbol)symbol;
        Symbol.MethodSymbol constructor = ASTHelpers.canonicalConstructor((Symbol.ClassSymbol)cs, (VisitorState)state);
        ImmutableList.Builder actuals = ImmutableList.builder();
        ImmutableList.Builder formals = ImmutableList.builder();
        for (int i = 0; i < ((List)constructor.getParameters()).size(); ++i) {
            if (!(tree.getNestedPatterns().get(i) instanceof BindingPatternTree)) continue;
            actuals.add((Object)((BindingPatternTree)tree.getNestedPatterns().get(i)).getVariable());
            formals.add((Object)((Symbol.VarSymbol)((List)constructor.getParameters()).get(i)));
        }
        return new InvocationInfo(tree, constructor, (ImmutableList<Tree>)actuals.build(), (ImmutableList<Symbol.VarSymbol>)formals.build(), state);
    }

    private static ImmutableList<Symbol.VarSymbol> getFormalParametersWithoutVarArgs(Symbol.MethodSymbol invokedMethodSymbol) {
        java.util.List formalParameters = invokedMethodSymbol.getParameters();
        if (!formalParameters.isEmpty() && ((Name)((Symbol.VarSymbol)formalParameters.getFirst()).getSimpleName()).toString().matches("this\\$[0-9]+")) {
            return ImmutableList.of();
        }
        int size = invokedMethodSymbol.isVarArgs() ? formalParameters.size() - 1 : formalParameters.size();
        return ImmutableList.copyOf(formalParameters.subList(0, size));
    }
}

