/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConstantCaseLabelTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Wildcard imports, static or otherwise, should not be used", severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, documentSuppression=false, tags={"Style"}, link="https://google.github.io/styleguide/javaguide.html?cl=head#s3.3.1-wildcard-imports")
public class WildcardImport
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public static final int MAX_MEMBER_IMPORTS = 20;

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableList<ImportTree> wildcardImports = WildcardImport.getWildcardImports(tree.getImports());
        if (wildcardImports.isEmpty()) {
            return Description.NO_MATCH;
        }
        Set<TypeToImport> typesToImport = ImportCollector.collect((JCTree.JCCompilationUnit)tree);
        Fix fix = WildcardImport.createFix(wildcardImports, typesToImport, state);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch((Tree)wildcardImports.getFirst(), fix);
    }

    private static ImmutableList<ImportTree> getWildcardImports(List<? extends ImportTree> imports) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ImportTree importTree : imports) {
            MemberSelectTree select;
            Tree ident = importTree.getQualifiedIdentifier();
            if (!(ident instanceof MemberSelectTree) || !(select = (MemberSelectTree)ident).getIdentifier().contentEquals("*")) continue;
            result.add((Object)importTree);
        }
        return result.build();
    }

    static Fix createFix(ImmutableList<ImportTree> wildcardImports, Set<TypeToImport> typesToImport, VisitorState state) {
        Map<Symbol, List<TypeToImport>> toFix = typesToImport.stream().collect(Collectors.groupingBy(TypeToImport::owner));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (ImportTree importToDelete : wildcardImports) {
            String importSpecification = state.getSourceForNode(importToDelete.getQualifiedIdentifier());
            if (importToDelete.isStatic()) {
                fix.removeStaticImport(importSpecification);
                continue;
            }
            fix.removeImport(importSpecification);
        }
        for (Map.Entry entry : toFix.entrySet()) {
            Symbol owner = (Symbol)entry.getKey();
            if (((Symbol)entry.getKey()).getKind() != ElementKind.PACKAGE && ((List)entry.getValue()).size() > 20) {
                WildcardImport.qualifiedNameFix(fix, owner, state);
                continue;
            }
            for (TypeToImport toImport : (List)entry.getValue()) {
                toImport.addFix(fix);
            }
        }
        return fix.build();
    }

    private static void qualifiedNameFix(final SuggestedFix.Builder fix, final Symbol owner, VisitorState state) {
        fix.addImport(owner.getQualifiedName().toString());
        final JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree);
                if (sym == null) {
                    return null;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (sym.owner.getKind() == ElementKind.ENUM) {
                    ConstantCaseLabelTree constantCaseLabel;
                    CaseTree caseTree;
                    if (parent instanceof CaseTree && (caseTree = (CaseTree)parent).getExpression().equals(tree)) {
                        return null;
                    }
                    if (parent instanceof ConstantCaseLabelTree && tree.equals((constantCaseLabel = (ConstantCaseLabelTree)parent).getConstantExpression())) {
                        return null;
                    }
                }
                if (sym.owner.equals(owner) && unit.starImportScope.includes(sym)) {
                    fix.prefixWith((Tree)tree, String.valueOf(owner.getSimpleName()) + ".");
                }
                return null;
            }
        }.scan(unit, null);
    }

    static class ImportCollector
    extends TreeScanner {
        private final Scope.StarImportScope wildcardScope;
        private final Set<TypeToImport> seen = new LinkedHashSet<TypeToImport>();

        ImportCollector(Scope.StarImportScope wildcardScope) {
            this.wildcardScope = wildcardScope;
        }

        public static Set<TypeToImport> collect(JCTree.JCCompilationUnit tree) {
            ImportCollector collector = new ImportCollector(tree.starImportScope);
            collector.scan(tree);
            return collector.seen;
        }

        @Override
        public void visitImport(JCTree.JCImport tree) {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl method) {
            if (ASTHelpers.isGeneratedConstructor((MethodTree)method)) {
                this.scan(method.body);
            } else {
                super.visitMethodDef(method);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            Symbol sym = tree.sym;
            if (sym == null) {
                return;
            }
            if (this.wildcardScope.includes(sym = sym.baseSymbol())) {
                if (sym.owner.getQualifiedName().contentEquals("java.lang")) {
                    return;
                }
                switch (sym.kind) {
                    case TYP: {
                        this.seen.add(TypeToImport.create(sym.getSimpleName().toString(), sym.owner, false));
                        break;
                    }
                    case VAR: 
                    case MTH: {
                        this.seen.add(TypeToImport.create(sym.getSimpleName().toString(), sym.owner, true));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    private record TypeToImport(String name, Symbol owner, boolean isStatic) {
        static TypeToImport create(String name, Symbol owner, boolean stat) {
            return new TypeToImport(name, owner, stat);
        }

        private void addFix(SuggestedFix.Builder fix) {
            String qualifiedName = String.valueOf(this.owner().getQualifiedName()) + "." + this.name();
            if (this.isStatic()) {
                fix.addStaticImport(qualifiedName);
            } else {
                fix.addImport(qualifiedName);
            }
        }
    }
}

