/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.ErrorPronePosition;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.FixedPosition;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="Unicode directionality modifiers can be used to conceal code in many editors.", disableable=false)
public final class UnicodeDirectionalityCharacters
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        CharSequence source = state.getSourceCode();
        block3: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\u202a': 
                case '\u202b': 
                case '\u202c': 
                case '\u202d': 
                case '\u202e': 
                case '\u2066': 
                case '\u2067': 
                case '\u2068': 
                case '\u2069': {
                    state.reportMatch(this.describeMatch((ErrorPronePosition)new FixedPosition((Tree)tree, i), (Fix)SuggestedFix.replace((int)i, (int)(i + 1), (String)String.format("\\u%04x", c))));
                    continue block3;
                }
            }
        }
        return Description.NO_MATCH;
    }
}

