/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Type;

public enum TypesWithUndefinedEquality {
    CHAR_SEQUENCE("CharSequence", "java.lang.CharSequence"),
    COLLECTION("Collection", "java.util.Collection"),
    DATE("Date", "java.util.Date"),
    FUTURE("Future", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture", "com.google.common.util.concurrent.ListenableFuture", "com.google.common.util.concurrent.SettableFuture"),
    IMMUTABLE_COLLECTION("ImmutableCollection", "com.google.common.collect.ImmutableCollection"),
    IMMUTABLE_MULTIMAP("ImmutableMultimap", "com.google.common.collect.ImmutableMultimap"),
    ITERABLE("Iterable", "com.google.common.collect.FluentIterable", "java.lang.Iterable"),
    LONG_SPARSE_ARRAY("LongSparseArray", "android.support.v4.util.LongSparseArrayCompat", "android.util.LongSparseArray", "androidx.collection.LongSparseArrayCompat", "androidx.core.util.LongSparseArrayCompat"),
    MULTIMAP("Multimap", "com.google.common.collect.Multimap"),
    QUEUE("Queue", "java.util.Queue"),
    SPARSE_ARRAY("SparseArray", "android.util.SparseArray", "androidx.collection.SparseArrayCompat");

    private final String shortName;
    private final ImmutableSet<String> typeNames;

    private TypesWithUndefinedEquality(String shortName, String ... typeNames) {
        this.shortName = shortName;
        this.typeNames = ImmutableSet.copyOf((Object[])typeNames);
    }

    public boolean matchesType(Type type, VisitorState state) {
        return this.typeNames.stream().anyMatch(typeName -> ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(typeName), (VisitorState)state));
    }

    public String shortName() {
        return this.shortName;
    }
}

