/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.Optional;

@BugPattern(tags={"Refactoring"}, summary="containsExactly is preferred over containsExactlyElementsIn when creating new iterables.", severity=BugPattern.SeverityLevel.WARNING)
public final class TruthContainsExactlyElementsInUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CONTAINS_EXACTLY_ELEMENTS_IN_METHOD_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.truth.IterableSubject").named("containsExactlyElementsIn");
    private static final Matcher<ExpressionTree> NEW_ITERABLE_MATCHERS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.collect.Lists").named("newArrayList"), Matchers.staticMethod().onClass("com.google.common.collect.ImmutableList").named("of"), Matchers.staticMethod().onClass("java.util.Arrays").named("asList"), Matchers.staticMethod().onClass("java.util.Collections").named("singletonList"), Matchers.staticMethod().onClass("java.util.List").named("of")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!CONTAINS_EXACTLY_ELEMENTS_IN_METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return TruthContainsExactlyElementsInUsage.getArgumentsFromNewIterableExpression(tree.getArguments().getFirst(), state).map(arguments -> this.describeMatch(tree, (Fix)TruthContainsExactlyElementsInUsage.refactor((ImmutableList<ExpressionTree>)arguments, tree, state))).orElse(Description.NO_MATCH);
    }

    private static Optional<ImmutableList<ExpressionTree>> getArgumentsFromNewIterableExpression(ExpressionTree expression, VisitorState state) {
        if (expression instanceof MethodInvocationTree) {
            MethodInvocationTree paramMethodInvocationTree = (MethodInvocationTree)expression;
            if (NEW_ITERABLE_MATCHERS.matches((Tree)expression, state)) {
                return Optional.of(ImmutableList.copyOf(paramMethodInvocationTree.getArguments()));
            }
        }
        if (expression instanceof NewArrayTree) {
            NewArrayTree newArrayTree = (NewArrayTree)expression;
            return Optional.of(ImmutableList.copyOf(newArrayTree.getInitializers()));
        }
        return Optional.empty();
    }

    private static SuggestedFix refactor(ImmutableList<ExpressionTree> arguments, MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"containsExactly", (VisitorState)state).toBuilder();
        ExpressionTree expressionToReplace = tree.getArguments().getFirst();
        if (!arguments.isEmpty()) {
            fix.replace(ASTHelpers.getStartPosition((Tree)expressionToReplace), ASTHelpers.getStartPosition((Tree)((Tree)arguments.getFirst())), "").replace(state.getEndPosition((Tree)Iterables.getLast(arguments)), state.getEndPosition((Tree)expressionToReplace), "");
        } else {
            fix.delete((Tree)expressionToReplace);
        }
        return fix.build();
    }
}

