/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Objects;

@BugPattern(summary="Scanner.useDelimiter is not an efficient way to read an entire InputStream", severity=BugPattern.SeverityLevel.WARNING)
public final class ScannerUseDelimiter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onExactClass("java.util.Scanner").named("useDelimiter").withParameters("java.lang.String", new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (!Objects.equals(ASTHelpers.constValue((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())), String.class), "\\A")) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

