/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Unused imports", severity=BugPattern.SeverityLevel.SUGGESTION, documentSuppression=false, tags={"Style"})
public final class RemoveUnusedImports
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree compilationUnitTree, VisitorState state) {
        final ImmutableSetMultimap<ImportTree, Symbol> importedSymbols = RemoveUnusedImports.getImportedSymbols(compilationUnitTree, state);
        if (importedSymbols.isEmpty()) {
            return Description.NO_MATCH;
        }
        final LinkedHashSet unusedImports = new LinkedHashSet(importedSymbols.keySet());
        new TreeSymbolScanner(JavacTrees.instance(state.context)).scan((Tree)compilationUnitTree, new SymbolSink(){

            @Override
            public boolean keepScanning() {
                return !unusedImports.isEmpty();
            }

            @Override
            public void accept(Symbol symbol) {
                unusedImports.removeAll((Collection<?>)importedSymbols.inverse().get((Object)symbol));
            }
        });
        if (unusedImports.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (ImportTree unusedImport : unusedImports) {
            fixBuilder.delete((Tree)unusedImport);
        }
        ImmutableSet unusedImportSimpleNames = (ImmutableSet)unusedImports.stream().map(tree -> RemoveUnusedImports.getSimpleName(tree).toString()).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap<String, String> actualMeanings = RemoveUnusedImports.actualMeanings((Set<String>)unusedImportSimpleNames, state);
        return this.buildDescription((Tree)unusedImports.iterator().next()).addFix((Fix)fixBuilder.build()).setMessage("Unused imports: " + unusedImports.stream().map(tree -> {
            String name = state.getSourceForNode(tree.getQualifiedIdentifier());
            ImmutableSet meanings = actualMeanings.get((Object)RemoveUnusedImports.getSimpleName(tree).toString());
            if (meanings.isEmpty()) {
                return name;
            }
            return String.format("%s (this name appears in the file, but resolves to %s)", name, meanings.stream().collect(Collectors.joining()));
        }).collect(Collectors.joining(", "))).build();
    }

    private static Name getSimpleName(ImportTree importTree) {
        Name name;
        Tree tree = importTree.getQualifiedIdentifier();
        if (tree instanceof IdentifierTree) {
            IdentifierTree idTree = (IdentifierTree)tree;
            name = idTree.getName();
        } else {
            name = ((MemberSelectTree)importTree.getQualifiedIdentifier()).getIdentifier();
        }
        return name;
    }

    private static ImmutableSetMultimap<ImportTree, Symbol> getImportedSymbols(CompilationUnitTree compilationUnitTree, VisitorState state) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            builder.putAll((Object)importTree, RemoveUnusedImports.getImportedSymbols(importTree, state));
        }
        return builder.build();
    }

    private static ImmutableSet<Symbol> getImportedSymbols(ImportTree importTree, VisitorState state) {
        if (importTree.isStatic()) {
            StaticImports.StaticImportInfo staticImportInfo = StaticImports.tryCreate(importTree, state);
            return staticImportInfo == null ? ImmutableSet.of() : staticImportInfo.members();
        }
        @Nullable Symbol importedSymbol = ASTHelpers.getSymbol((Tree)importTree.getQualifiedIdentifier());
        return importedSymbol == null ? ImmutableSet.of() : ImmutableSet.of((Object)importedSymbol);
    }

    private static ImmutableSetMultimap<String, String> actualMeanings(final Set<String> simpleNames, VisitorState state) {
        final ImmutableSetMultimap.Builder meanings = ImmutableSetMultimap.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitImport(ImportTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (simpleNames.contains(symbol.getSimpleName().toString())) {
                    meanings.put((Object)symbol.getSimpleName().toString(), symbol instanceof Symbol.MethodSymbol || symbol instanceof Symbol.VarSymbol ? String.valueOf(symbol.owner.getQualifiedName()) + "#" + String.valueOf(symbol.getSimpleName()) : symbol.getQualifiedName().toString());
                }
                return null;
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return meanings.build();
    }

    private static final class TreeSymbolScanner
    extends TreePathScanner<Void, SymbolSink> {
        final DocTreeSymbolScanner docTreeSymbolScanner = new DocTreeSymbolScanner();
        final JavacTrees trees;

        private TreeSymbolScanner(JavacTrees trees) {
            this.trees = trees;
        }

        @Override
        public Void visitImport(ImportTree importTree, SymbolSink usedSymbols) {
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, SymbolSink sink) {
            if (tree == null) {
                return null;
            }
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            if (symbol == null) {
                return null;
            }
            sink.accept(symbol.baseSymbol());
            return null;
        }

        @Override
        public Void visitClass(ClassTree node, SymbolSink symbolSink) {
            if (node.getKind().equals((Object)Tree.Kind.RECORD)) {
                ASTHelpers.getEnclosedElements((Symbol)ASTHelpers.getSymbol((ClassTree)node)).stream().flatMap(e -> e.getAnnotationMirrors().stream()).map(a -> (Symbol)a.getAnnotationType().asElement()).forEach(symbolSink::accept);
            }
            return (Void)super.visitClass(node, symbolSink);
        }

        @Override
        public Void scan(Tree tree, SymbolSink sink) {
            if (!sink.keepScanning()) {
                return null;
            }
            if (tree == null) {
                return null;
            }
            this.scanJavadoc(sink);
            return (Void)super.scan(tree, sink);
        }

        private void scanJavadoc(SymbolSink sink) {
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), commentTree), sink);
        }

        final class DocTreeSymbolScanner
        extends DocTreePathScanner<Void, SymbolSink> {
            DocTreeSymbolScanner() {
            }

            @Override
            public Void visitReference(ReferenceTree referenceTree, SymbolSink sink) {
                TreeSymbolScanner.this.trees.getElement(this.getCurrentPath());
                TreeScanner<Void, SymbolSink> nonRecursiveScanner = new TreeScanner<Void, SymbolSink>(this){

                    @Override
                    public Void visitIdentifier(IdentifierTree tree, SymbolSink sink) {
                        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
                        if (sym != null) {
                            sink.accept(sym);
                        }
                        return null;
                    }
                };
                DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
                nonRecursiveScanner.scan(reference.qualifierExpression, sink);
                nonRecursiveScanner.scan(reference.paramTypes, sink);
                return null;
            }
        }
    }

    private static interface SymbolSink {
        public boolean keepScanning();

        public void accept(Symbol var1);
    }
}

