/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.MisusedDateFormat;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Reuse of DateFormat fields is most likely unintentional", severity=BugPattern.SeverityLevel.WARNING)
public final class DuplicateDateFormatField
extends MisusedDateFormat {
    private static final ImmutableSet<Character> PATTERN_CHARACTERS = ImmutableSet.of((Object)Character.valueOf('G'), (Object)Character.valueOf('y'), (Object)Character.valueOf('Y'), (Object)Character.valueOf('M'), (Object)Character.valueOf('L'), (Object)Character.valueOf('w'), (Object[])new Character[]{Character.valueOf('W'), Character.valueOf('D'), Character.valueOf('d'), Character.valueOf('F'), Character.valueOf('E'), Character.valueOf('u'), Character.valueOf('a'), Character.valueOf('H'), Character.valueOf('k'), Character.valueOf('K'), Character.valueOf('h'), Character.valueOf('m'), Character.valueOf('s'), Character.valueOf('S'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('X')});

    @Override
    public Optional<String> rewriteTo(String pattern) {
        return Optional.empty();
    }

    @Override
    Description constructDescription(Tree tree, ExpressionTree patternArg, VisitorState state) {
        Optional<String> pattern = Optional.ofNullable((String)ASTHelpers.constValue((Tree)patternArg, String.class));
        if (pattern.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Character> duplicates = PatternCounter.getDuplicates(pattern.get());
        if (!duplicates.isEmpty()) {
            return this.buildDescription(tree).setMessage(DuplicateDateFormatField.buildMessage(pattern.get(), duplicates)).build();
        }
        return Description.NO_MATCH;
    }

    private static String buildMessage(String pattern, ImmutableSet<Character> duplicates) {
        String duplicatedFields = duplicates.stream().sorted().map(c -> "'" + c + "'").collect(Collectors.joining(", "));
        String fieldDescription = duplicates.size() > 1 ? String.format("the fields [%s]", duplicatedFields) : String.format("the field %s", duplicatedFields);
        return String.format("DateFormat pattern \"%s\" uses %s more than once. Reuse of DateFormat fields is most likely unintentional.", pattern, fieldDescription);
    }

    private static class PatternCounter
    implements MisusedDateFormat.DateFormatConsumer {
        private final Set<Character> seen = new HashSet<Character>();
        private final Set<Character> duplicates = new HashSet<Character>();
        private @Nullable Character prev = null;
        private int optionalGroupDepth = 0;

        private PatternCounter() {
        }

        @Override
        public void consumeSpecial(char special) {
            if (special == '[') {
                ++this.optionalGroupDepth;
            } else if (special == ']') {
                --this.optionalGroupDepth;
            }
            if (!PATTERN_CHARACTERS.contains((Object)Character.valueOf(special)) || this.optionalGroupDepth > 0) {
                this.prev = null;
                return;
            }
            if (this.prev == null || this.prev.charValue() != special) {
                if (!this.seen.add(Character.valueOf(special))) {
                    this.duplicates.add(Character.valueOf(special));
                }
                this.prev = Character.valueOf(special);
            }
        }

        @Override
        public void consumeLiteral(char literal) {
            this.prev = null;
        }

        Set<Character> getDuplicates() {
            return this.duplicates;
        }

        static ImmutableSet<Character> getDuplicates(String pattern) {
            PatternCounter counter = new PatternCounter();
            MisusedDateFormat.parseDateFormat(pattern, counter);
            return ImmutableSet.copyOf(counter.getDuplicates());
        }
    }
}

