/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="The called constructor accepts a parameter with the same name and type as one of its caller's parameters, but its caller doesn't pass that parameter to it.  It's likely that it was intended to.")
public final class ChainingConstructorIgnoresParameter
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher {
    private final Map<Symbol.MethodSymbol, List<VariableTree>> paramTypesForMethod = Maps.newHashMap();
    private final ListMultimap<Symbol.MethodSymbol, Caller> callersToEvaluate = ArrayListMultimap.create();

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        this.paramTypesForMethod.clear();
        this.callersToEvaluate.clear();
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!ChainingConstructorIgnoresParameter.isIdentifierWithName(tree.getMethodSelect(), "this")) {
            return Description.NO_MATCH;
        }
        this.callersToEvaluate.put((Object)symbol, (Object)new Caller(tree, state));
        return this.evaluateCallers(symbol);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (!symbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        this.paramTypesForMethod.put(symbol, Collections.unmodifiableList(tree.getParameters()));
        return this.evaluateCallers(symbol);
    }

    private Description evaluateCallers(Symbol.MethodSymbol symbol) {
        List<VariableTree> paramTypes = this.paramTypesForMethod.get(symbol);
        if (paramTypes == null) {
            return Description.NO_MATCH;
        }
        for (Caller caller : this.callersToEvaluate.removeAll((Object)symbol)) {
            VisitorState state = caller.state;
            MethodInvocationTree invocation = caller.tree;
            MethodTree callerConstructor = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
            if (callerConstructor == null) continue;
            Map<String, Type> availableParams = ChainingConstructorIgnoresParameter.indexTypeByName(callerConstructor.getParameters());
            for (int i = 0; i < paramTypes.size() && i < invocation.getArguments().size(); ++i) {
                VariableTree formalParam = paramTypes.get(i);
                String formalParamName = formalParam.getName().toString();
                Type formalParamType = ASTHelpers.getType((Tree)formalParam.getType());
                Type availableParamType = availableParams.get(formalParamName);
                ExpressionTree actualParam = invocation.getArguments().get(i);
                if (availableParamType == null || formalParamType == null || ChainingConstructorIgnoresParameter.referencesIdentifierWithName(formalParamName, actualParam, state) || !state.getTypes().isAssignable(availableParamType, formalParamType)) continue;
                this.reportMatch(invocation, state, actualParam, formalParamName);
            }
        }
        return Description.NO_MATCH;
    }

    private static Map<String, Type> indexTypeByName(List<? extends VariableTree> parameters) {
        HashMap result = Maps.newHashMap();
        for (VariableTree variableTree : parameters) {
            result.put(variableTree.getName().toString(), ASTHelpers.getType((Tree)variableTree.getType()));
        }
        return result;
    }

    private void reportMatch(Tree diagnosticPosition, VisitorState state, Tree toReplace, String replaceWith) {
        state.reportMatch(this.describeMatch(diagnosticPosition, (Fix)SuggestedFix.replace((Tree)toReplace, (String)replaceWith)));
    }

    private static boolean referencesIdentifierWithName(final String name, ExpressionTree tree, VisitorState state) {
        Matcher<IdentifierTree> identifierMatcher = new Matcher<IdentifierTree>(){

            public boolean matches(IdentifierTree tree, VisitorState state) {
                return ChainingConstructorIgnoresParameter.isIdentifierWithName(tree, name);
            }
        };
        return Matchers.hasIdentifier((Matcher)identifierMatcher).matches((Tree)tree, state);
    }

    private static boolean isIdentifierWithName(ExpressionTree tree, String name) {
        IdentifierTree identifierTree;
        return tree instanceof IdentifierTree && (identifierTree = (IdentifierTree)tree).getName().contentEquals(name);
    }

    private static final class Caller {
        final MethodInvocationTree tree;
        final VisitorState state;

        Caller(MethodInvocationTree tree, VisitorState state) {
            this.tree = tree;
            this.state = state;
        }
    }
}

