/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

@BugPattern(summary="Importing nested classes/static methods/static fields with commonly-used names can make code harder to read, because it may not be clear from the context exactly which type is being referred to. Qualifying the name with that of the containing class can make the code clearer.", severity=BugPattern.SeverityLevel.WARNING)
public class BadImport
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    static final ImmutableSet<String> BAD_NESTED_CLASSES = ImmutableSet.of((Object)"Builder", (Object)"BuilderFactory", (Object)"Callback", (Object)"Class", (Object)"Enum", (Object)"Factory", (Object[])new String[]{"Type", "Key", "Id", "Provider"});
    private static final ImmutableSet<String> BAD_STATIC_IDENTIFIERS = ImmutableSet.of((Object)"INSTANCE", (Object)"builder", (Object)"copyOf", (Object)"create", (Object)"from", (Object)"getDefaultInstance", (Object[])new String[]{"newBuilder", "newInstance", "of", "valueOf", "values"});
    private static final MultiMatcher<Tree, AnnotationTree> HAS_TYPE_USE_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher & Serializable)(t, state) -> BadImport.isTypeAnnotation(t));
    private static final String MESSAGE_LITE = "com.google.protobuf.MessageLite";
    private final ImmutableSet<String> badEnclosingTypes;
    private final boolean warnAboutTruth8AssertThat;
    private static final Supplier<Type> COM_GOOGLE_PROTOBUF_MESSAGELITE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(MESSAGE_LITE));

    @Inject
    BadImport(ErrorProneFlags errorProneFlags) {
        this.badEnclosingTypes = errorProneFlags.getSetOrEmpty("BadImport:BadEnclosingTypes");
        this.warnAboutTruth8AssertThat = errorProneFlags.getBoolean("BadImport:Truth8").orElse(false);
    }

    public Description matchImport(ImportTree tree, VisitorState state) {
        ImmutableSet symbols;
        Symbol symbol;
        boolean useTruth8Message = false;
        if (!tree.isStatic()) {
            symbol = ASTHelpers.getSymbol((Tree)tree.getQualifiedIdentifier());
            if (symbol == null || this.isAcceptableImport(symbol, (Set<String>)BAD_NESTED_CLASSES)) {
                return Description.NO_MATCH;
            }
            symbols = ImmutableSet.of((Object)symbol);
        } else {
            StaticImports.StaticImportInfo staticImportInfo = StaticImports.tryCreate(tree, state);
            if (staticImportInfo == null || staticImportInfo.members().isEmpty()) {
                return Description.NO_MATCH;
            }
            symbols = staticImportInfo.members();
            symbol = (Symbol)symbols.iterator().next();
            if (this.warnAboutTruth8AssertThat && symbol.owner.name.contentEquals("Truth8")) {
                useTruth8Message = true;
            } else if (this.isAcceptableImport(symbol, (Set<String>)BAD_STATIC_IDENTIFIERS)) {
                return Description.NO_MATCH;
            }
        }
        if (state.getPath().getCompilationUnit().getTypeDecls().stream().anyMatch(c -> symbol.outermostClass().equals(ASTHelpers.getSymbol((Tree)c)))) {
            return Description.NO_MATCH;
        }
        if (symbol.getEnclosingElement() instanceof Symbol.PackageSymbol) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype((Type)symbol.type, (Type)((Type)COM_GOOGLE_PROTOBUF_MESSAGELITE.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder().removeImport(symbol.getQualifiedName().toString());
        String replacement = SuggestedFixes.qualifyType((VisitorState)BadImport.getCheckState(state), (SuggestedFix.Builder)builder, (Symbol)symbol.getEnclosingElement()) + ".";
        String message = useTruth8Message ? "Avoid static import for Truth8.assertThat. While we usually recommend static import for assertThat methods, static imports of Truth8.assertThat prevent us from copying those methods to the main Truth class." : String.format("Importing nested classes/static methods/static fields with commonly-used names can make code harder to read, because it may not be clear from the context exactly which type is being referred to. Qualifying the name with that of the containing class can make the code clearer. Here we recommend using qualified class: %s", replacement);
        return this.buildDescription(builder, (Set<Symbol>)symbols, replacement, state, message);
    }

    private static VisitorState getCheckState(VisitorState state) {
        ClassTree classTree;
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        if (compilationUnit.getTypeDecls().isEmpty()) {
            return state;
        }
        Tree tree = compilationUnit.getTypeDecls().getFirst();
        if (!(tree instanceof ClassTree) || (classTree = (ClassTree)tree).getMembers().isEmpty()) {
            return state;
        }
        return state.withPath(TreePath.getPath(compilationUnit, classTree.getMembers().getFirst()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAcceptableImport(Symbol symbol, Set<String> badNames) {
        Name ownerName = symbol.owner.getQualifiedName();
        Name simpleName = symbol.getSimpleName();
        if (!this.badEnclosingTypes.stream().noneMatch(ownerName::contentEquals)) return false;
        if (!badNames.stream().noneMatch(simpleName::contentEquals)) return false;
        return true;
    }

    private Description buildDescription(final SuggestedFix.Builder builder, final Set<Symbol> symbols, final String enclosingReplacement, VisitorState state, String message) {
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        TreePath path = TreePath.getPath(compilationUnit, (Tree)compilationUnit);
        IdentifierTree firstFound = (IdentifierTree)new BugChecker.SuppressibleTreePathScanner<IdentifierTree, Void>(this, state){
            final /* synthetic */ BadImport this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public IdentifierTree reduce(IdentifierTree r1, IdentifierTree r2) {
                return r2 != null ? r2 : r1;
            }

            public IdentifierTree visitIdentifier(IdentifierTree node, Void unused) {
                Symbol nodeSymbol = ASTHelpers.getSymbol((Tree)node);
                if (symbols.contains(nodeSymbol) && !this.this$0.isSuppressed(node, this.state) && !(this.getCurrentPath().getParentPath().getLeaf() instanceof CaseTree)) {
                    builder.prefixWith((Tree)node, enclosingReplacement);
                    this.moveTypeAnnotations(node);
                    return node;
                }
                return (IdentifierTree)super.visitIdentifier(node, null);
            }

            private void moveTypeAnnotations(IdentifierTree node) {
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                switch (parent.getKind()) {
                    case METHOD: 
                    case VARIABLE: 
                    case ANNOTATED_TYPE: {
                        this.moveTypeAnnotations(node, parent, this.state, builder);
                        break;
                    }
                    case PARAMETERIZED_TYPE: {
                        Tree grandParent = this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                        if (!(grandParent instanceof VariableTree) && !(grandParent instanceof MethodTree)) break;
                        this.moveTypeAnnotations(node, grandParent, this.state, builder);
                        break;
                    }
                }
            }

            private void moveTypeAnnotations(IdentifierTree node, Tree annotationHolder, VisitorState state, SuggestedFix.Builder builder2) {
                for (AnnotationTree annotation : HAS_TYPE_USE_ANNOTATION.multiMatchResult(annotationHolder, state).matchingNodes()) {
                    builder2.delete((Tree)annotation);
                    builder2.prefixWith((Tree)node, state.getSourceForNode((Tree)annotation) + " ");
                }
            }
        }.scan(path, null);
        if (firstFound == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(firstFound).setMessage(message).addFix((Fix)builder.build()).build();
    }

    private static boolean isTypeAnnotation(AnnotationTree t) {
        Symbol annotationSymbol = ASTHelpers.getSymbol((Tree)t.getAnnotationType());
        if (annotationSymbol == null) {
            return false;
        }
        Target target = annotationSymbol.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        List<ElementType> value = Arrays.asList(target.value());
        return value.contains((Object)ElementType.TYPE_USE) || value.contains((Object)ElementType.TYPE_PARAMETER);
    }
}

