/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

@BugPattern(summary="The use of an assignment expression can be surprising and hard to read; consider factoring out the assignment to a separate statement.", severity=BugPattern.SeverityLevel.WARNING)
public final class AssignmentExpression
extends BugChecker
implements BugChecker.AssignmentTreeMatcher {
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof ExpressionStatementTree) {
            return Description.NO_MATCH;
        }
        if (parent instanceof AnnotationTree) {
            return Description.NO_MATCH;
        }
        if (parent instanceof LambdaExpressionTree) {
            return Description.NO_MATCH;
        }
        if (parent instanceof ParenthesizedTree && state.getPath().getParentPath().getParentPath().getLeaf() instanceof BinaryTree) {
            return Description.NO_MATCH;
        }
        if (AssignmentExpression.isDuplicateAssignment(tree, parent)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)tree.getExpression())));
        }
        if (parent instanceof AssignmentTree) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean isDuplicateAssignment(AssignmentTree tree, Tree parent) {
        Object object;
        if (!(tree.getVariable() instanceof IdentifierTree) || !((object = ASTHelpers.getSymbol((Tree)tree.getVariable())) instanceof Symbol.VarSymbol)) {
            return false;
        }
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)object;
        Tree tree2 = parent;
        Objects.requireNonNull(tree2);
        object = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AssignmentTree.class, VariableTree.class}, (Object)object, n)) {
            case 0 -> {
                IdentifierTree identifierTree;
                AssignmentTree assignmentTree = (AssignmentTree)object;
                ExpressionTree var7_6 = assignmentTree.getVariable();
                if (var7_6 instanceof IdentifierTree && varSymbol.equals(ASTHelpers.getSymbol((Tree)(identifierTree = (IdentifierTree)var7_6)))) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                VariableTree variableTree = (VariableTree)object;
                yield varSymbol.equals(ASTHelpers.getSymbol((VariableTree)variableTree));
            }
            default -> false;
        };
    }
}

