/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This assertion throws an AssertionError if it fails, which will be caught by an enclosing try block.", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class AssertionFailureIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERTION = MethodMatchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).withNameMatching(Pattern.compile("fail|assert.*"));
    private static final Matcher<ExpressionTree> NEW_THROWABLE = MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf((String)"java.lang.Throwable"));

    public Description matchMethodInvocation(MethodInvocationTree tree, final VisitorState state) {
        if (!ASSERTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        JCTree.JCTry tryStatement = AssertionFailureIgnored.enclosingTry(state);
        if (tryStatement == null) {
            return Description.NO_MATCH;
        }
        Optional<JCTree.JCCatch> maybeCatchTree = AssertionFailureIgnored.catchesType(tryStatement, state.getSymtab().assertionErrorType, state);
        if (maybeCatchTree.isEmpty()) {
            return Description.NO_MATCH;
        }
        JCTree.JCCatch catchTree = maybeCatchTree.get();
        final Symbol.VarSymbol parameter = ASTHelpers.getSymbol((VariableTree)catchTree.getParameter());
        boolean rethrows = (Boolean)MoreObjects.firstNonNull((Object)((Boolean)new TreeScanner<Boolean, Void>(this){

            @Override
            public Boolean visitThrow(ThrowTree tree, Void unused) {
                if (Objects.equals(parameter, ASTHelpers.getSymbol((Tree)tree.getExpression()))) {
                    return true;
                }
                if (NEW_THROWABLE.matches((Tree)tree.getExpression(), state) && ((NewClassTree)tree.getExpression()).getArguments().stream().anyMatch(arg -> Objects.equals(parameter, ASTHelpers.getSymbol((Tree)arg)))) {
                    return true;
                }
                return (Boolean)super.visitThrow(tree, null);
            }

            @Override
            public Boolean reduce(Boolean a, Boolean b) {
                return (Boolean)MoreObjects.firstNonNull((Object)a, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)b, (Object)false) != false;
            }
        }.scan(catchTree.getBlock(), null)), (Object)false);
        if (rethrows) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        AssertionFailureIgnored.buildFix(tryStatement, tree, state).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }

    private static Optional<Fix> buildFix(TryTree tryStatement, MethodInvocationTree tree, VisitorState state) {
        int endPosition;
        int startPosition;
        boolean expression;
        if (!((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).contentEquals("fail")) {
            return Optional.empty();
        }
        BlockTree block = tryStatement.getBlock();
        if (!Matchers.expressionStatement((Matcher & Serializable)(t, s) -> t.equals(tree)).matches((Tree)((StatementTree)Iterables.getLast(block.getStatements())), state)) {
            return Optional.empty();
        }
        if (tryStatement.getCatches().size() != 1) {
            return Optional.empty();
        }
        CatchTree catchTree = (CatchTree)Iterables.getOnlyElement(tryStatement.getCatches());
        if (catchTree.getParameter().getType() instanceof UnionTypeTree) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        boolean bl = expression = block.getStatements().size() == 2 && block.getStatements().getFirst() instanceof ExpressionStatementTree;
        if (expression) {
            ExpressionStatementTree expressionTree = (ExpressionStatementTree)block.getStatements().getFirst();
            startPosition = ASTHelpers.getStartPosition((Tree)expressionTree);
            endPosition = state.getEndPosition((Tree)expressionTree.getExpression());
        } else {
            startPosition = ASTHelpers.getStartPosition((Tree)block);
            endPosition = ASTHelpers.getStartPosition((Tree)((Tree)Iterables.getLast(tryStatement.getBlock().getStatements())));
        }
        if (catchTree.getBlock().getStatements().isEmpty()) {
            fix.addStaticImport("org.junit.Assert.assertThrows");
            fix.replace(ASTHelpers.getStartPosition((Tree)tryStatement), startPosition, String.format("assertThrows(%s.class, () -> ", state.getSourceForNode(catchTree.getParameter().getType()))).replace(endPosition, state.getEndPosition((Tree)catchTree), (expression ? "" : "}") + ");\n");
        } else {
            fix.addStaticImport("org.junit.Assert.assertThrows").prefixWith((Tree)tryStatement, state.getSourceForNode((Tree)catchTree.getParameter())).replace(ASTHelpers.getStartPosition((Tree)tryStatement), startPosition, String.format(" = assertThrows(%s.class, () -> ", state.getSourceForNode(catchTree.getParameter().getType()))).replace(endPosition, ASTHelpers.getStartPosition((Tree)catchTree.getBlock().getStatements().getFirst()), (expression ? "" : "}") + ");\n").replace(state.getEndPosition((Tree)Iterables.getLast(catchTree.getBlock().getStatements())), state.getEndPosition((Tree)catchTree), "");
        }
        return Optional.of(fix.build());
    }

    private static Optional<JCTree.JCCatch> catchesType(JCTree.JCTry tryStatement, Type assertionErrorType, VisitorState state) {
        return tryStatement.getCatches().stream().filter(catchTree -> {
            Type type = ASTHelpers.getType((Tree)catchTree.getParameter());
            return (type.isUnion() ? Streams.stream(((Type.UnionClassType)type).getAlternativeTypes()) : Stream.of(type)).anyMatch(caught -> ASTHelpers.isSubtype((Type)assertionErrorType, (Type)caught, (VisitorState)state));
        }).findFirst();
    }

    private static  @Nullable JCTree.JCTry enclosingTry(VisitorState state) {
        Tree prev = null;
        for (Tree parent : state.getPath()) {
            Tree tree;
            Objects.requireNonNull(parent);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodTree.class, LambdaExpressionTree.class, JCTree.JCTry.class}, (Object)tree, n)) {
                case 0: {
                    MethodTree mt = (MethodTree)tree;
                    return null;
                }
                case 1: {
                    LambdaExpressionTree let = (LambdaExpressionTree)tree;
                    return null;
                }
                case 2: {
                    JCTree.JCTry tryStatement = (JCTree.JCTry)tree;
                    return tryStatement.getBlock().equals(prev) ? tryStatement : null;
                }
            }
            prev = parent;
        }
        return null;
    }
}

