/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.type.TypeKind;

@CheckReturnValue
public final class UnusedReturnValueMatcher
implements Matcher<ExpressionTree> {
    private static final ImmutableMap<AllowReason, Matcher<ExpressionTree>> ALLOW_MATCHERS = ImmutableMap.of((Object)((Object)AllowReason.MOCKING_CALL), UnusedReturnValueMatcher::mockitoInvocation, (Object)((Object)AllowReason.EXCEPTION_TESTING), UnusedReturnValueMatcher::exceptionTesting, (Object)((Object)AllowReason.RETURNS_JAVA_LANG_VOID), UnusedReturnValueMatcher::returnsJavaLangVoid);
    private static final ImmutableSet<AllowReason> DISALLOW_EXCEPTION_TESTING = Sets.immutableEnumSet((Iterable)Sets.filter((Set)ALLOW_MATCHERS.keySet(), k -> !k.equals((Object)AllowReason.EXCEPTION_TESTING)));
    private final ImmutableSet<AllowReason> validAllowReasons;
    private static final Matcher<ExpressionTree> FAIL_METHOD = Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("com.google.common.truth.AbstractVerb").named("fail"), Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("fail"), Matchers.staticMethod().onClass("org.junit.Assert").named("fail"), Matchers.staticMethod().onClass("junit.framework.Assert").named("fail"), Matchers.staticMethod().onClass("junit.framework.TestCase").named("fail"));
    private static final Matcher<StatementTree> EXPECTED_EXCEPTION_MATCHER = Matchers.anyOf(Matchers.allOf(Matchers.isLastStatementInBlock(), Matchers.previousStatement(Matchers.expressionStatement(Matchers.anyOf(Matchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException"))))), Matchers.allOf(Matchers.enclosingNode(Matchers.kindIs(Tree.Kind.TRY)), Matchers.nextStatement(Matchers.expressionStatement(FAIL_METHOD))), Matchers.allOf(Matchers.anyOf(Matchers.isLastStatementInBlock(), Matchers.parentNode(Matchers.kindIs(Tree.Kind.LAMBDA_EXPRESSION))), (t, s) -> Matchers.methodCallInDeclarationOfThrowingRunnable(s)), Matchers.allOf(UnusedReturnValueMatcher::isOnlyStatementInBlock, Matchers.enclosingMethod(UnusedReturnValueMatcher::isTestExpectedExceptionMethod)));
    private static final Matcher<ExpressionTree> MOCKITO_MATCHER = Matchers.anyOf(Matchers.staticMethod().onClass("org.mockito.Mockito").named("verify"), Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when"), Matchers.instanceMethod().onDescendantOf("org.mockito.InOrder").named("verify"));

    public static UnusedReturnValueMatcher get(boolean allowInExceptionThrowers) {
        return new UnusedReturnValueMatcher((ImmutableSet<AllowReason>)(allowInExceptionThrowers ? ALLOW_MATCHERS.keySet() : DISALLOW_EXCEPTION_TESTING));
    }

    private UnusedReturnValueMatcher(ImmutableSet<AllowReason> validAllowReasons) {
        this.validAllowReasons = validAllowReasons;
    }

    @Override
    public boolean matches(ExpressionTree tree, VisitorState state) {
        return UnusedReturnValueMatcher.isReturnValueUnused(tree, state) && !this.isAllowed(tree, state);
    }

    private static boolean isVoidMethod(Symbol.MethodSymbol symbol) {
        return !symbol.isConstructor() && UnusedReturnValueMatcher.isVoid(symbol.getReturnType());
    }

    private static boolean isVoid(Type type) {
        return type.getKind() == TypeKind.VOID;
    }

    private static boolean implementsVoidMethod(ExpressionTree tree, VisitorState state) {
        return UnusedReturnValueMatcher.isVoid(state.getTypes().findDescriptorType(ASTHelpers.getType(tree)).getReturnType());
    }

    public static boolean isReturnValueUnused(ExpressionTree tree, VisitorState state) {
        boolean bl;
        Symbol.MethodSymbol methodSymbol;
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (!(sym instanceof Symbol.MethodSymbol) || UnusedReturnValueMatcher.isVoidMethod(methodSymbol = (Symbol.MethodSymbol)sym)) {
            return false;
        }
        if (tree instanceof MemberReferenceTree) {
            return UnusedReturnValueMatcher.implementsVoidMethod(tree, state);
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof LambdaExpressionTree) {
            LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)parent;
            bl = UnusedReturnValueMatcher.implementsVoidMethod(lambdaExpressionTree, state);
        } else {
            bl = parent instanceof ExpressionStatementTree;
        }
        return bl;
    }

    public boolean isAllowed(ExpressionTree tree, VisitorState state) {
        return this.getAllowReasons(tree, state).findAny().isPresent();
    }

    public Stream<AllowReason> getAllowReasons(ExpressionTree tree, VisitorState state) {
        return this.validAllowReasons.stream().filter(reason -> ((Matcher)ALLOW_MATCHERS.get((Object)reason)).matches(tree, state));
    }

    private static boolean returnsJavaLangVoid(ExpressionTree tree, VisitorState state) {
        boolean bl;
        if (tree instanceof MemberReferenceTree) {
            MemberReferenceTree memberReferenceTree = (MemberReferenceTree)tree;
            bl = UnusedReturnValueMatcher.returnsJavaLangVoid(memberReferenceTree, state);
        } else {
            bl = ASTHelpers.isVoidType(ASTHelpers.getResultType(tree), state);
        }
        return bl;
    }

    private static boolean returnsJavaLangVoid(MemberReferenceTree tree, VisitorState state) {
        if (tree.getMode() == MemberReferenceTree.ReferenceMode.NEW) {
            return false;
        }
        Type type = state.getTypes().memberType(ASTHelpers.getType(tree.getQualifierExpression()), ASTHelpers.getSymbol(tree));
        return type instanceof Type.MethodType && ASTHelpers.isVoidType(type.getReturnType(), state);
    }

    private static boolean exceptionTesting(ExpressionTree tree, VisitorState state) {
        return tree instanceof MemberReferenceTree ? Matchers.isThrowingFunctionalInterface(ASTHelpers.getType(tree), state) : UnusedReturnValueMatcher.expectedExceptionTest(state);
    }

    private static boolean isTestExpectedExceptionMethod(MethodTree tree, VisitorState state) {
        if (!JUnitMatchers.wouldRunInJUnit4.matches(tree, state)) {
            return false;
        }
        return ASTHelpers.getSymbol(tree).getAnnotationMirrors().stream().filter(am -> am.type.tsym.getQualifiedName().contentEquals("org.junit.Test")).findFirst().flatMap(testAm -> MoreAnnotations.getAnnotationValue(testAm, "expected")).flatMap(MoreAnnotations::asTypeValue).filter(tv -> !tv.toString().equals("org.junit.Test.None")).isPresent();
    }

    private static boolean isOnlyStatementInBlock(StatementTree t, VisitorState s) {
        BlockTree parentBlock = ASTHelpers.findEnclosingNode(s.getPath(), BlockTree.class);
        return parentBlock != null && parentBlock.getStatements().size() == 1 && Iterables.getOnlyElement(parentBlock.getStatements()) == t;
    }

    public static boolean expectedExceptionTest(VisitorState state) {
        StatementTree statement = ASTHelpers.findEnclosingNode(state.getPath(), StatementTree.class);
        return statement != null && EXPECTED_EXCEPTION_MATCHER.matches(statement, state);
    }

    public static boolean mockitoInvocation(Tree tree, VisitorState state) {
        if (!(tree instanceof JCTree.JCMethodInvocation)) {
            return false;
        }
        JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)tree;
        if (!(invocation.getMethodSelect() instanceof JCTree.JCFieldAccess)) {
            return false;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(invocation);
        return MOCKITO_MATCHER.matches(receiver, state);
    }

    public static enum AllowReason {
        EXCEPTION_TESTING,
        MOCKING_CALL,
        RETURNS_JAVA_LANG_VOID,
        KNOWN_BUILDER_SETTER;

    }
}

