/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class Enclosing {
    private Enclosing() {
    }

    public static class BlockOrCase<T extends Tree>
    implements Matcher<T> {
        private final Matcher<BlockTree> blockTreeMatcher;
        private final Matcher<CaseTree> caseTreeMatcher;

        public BlockOrCase(Matcher<BlockTree> blockTreeMatcher, Matcher<CaseTree> caseTreeMatcher) {
            this.blockTreeMatcher = blockTreeMatcher;
            this.caseTreeMatcher = caseTreeMatcher;
        }

        @Override
        public boolean matches(T unused, VisitorState state) {
            TreePath pathToEnclosing = state.findPathToEnclosing(CaseTree.class, BlockTree.class);
            if (pathToEnclosing == null) {
                return false;
            }
            Tree enclosing = pathToEnclosing.getLeaf();
            state = state.withPath(pathToEnclosing);
            if (enclosing instanceof BlockTree) {
                BlockTree blockTree = (BlockTree)enclosing;
                return this.blockTreeMatcher.matches(blockTree, state);
            }
            if (enclosing instanceof CaseTree) {
                CaseTree caseTree = (CaseTree)enclosing;
                return this.caseTreeMatcher.matches(caseTree, state);
            }
            throw new IllegalStateException("enclosing tree not a BlockTree or CaseTree");
        }
    }

    public static class Method<T extends Tree>
    extends EnclosingMatcher<MethodTree, T> {
        public Method(Matcher<MethodTree> matcher) {
            super(matcher, MethodTree.class);
        }
    }

    public static class Class<T extends Tree>
    extends EnclosingMatcher<ClassTree, T> {
        public Class(Matcher<ClassTree> matcher) {
            super(matcher, ClassTree.class);
        }
    }

    public static class Block<T extends Tree>
    extends EnclosingMatcher<BlockTree, T> {
        public Block(Matcher<BlockTree> matcher) {
            super(matcher, BlockTree.class);
        }
    }

    private static abstract class EnclosingMatcher<T extends Tree, U extends Tree>
    implements Matcher<U> {
        final Matcher<T> matcher;
        final java.lang.Class<T> clazz;

        EnclosingMatcher(Matcher<T> matcher, java.lang.Class<T> clazz) {
            this.matcher = matcher;
            this.clazz = clazz;
        }

        @Override
        public boolean matches(U unused, VisitorState state) {
            TreePath pathToEnclosing = state.findPathToEnclosing(this.clazz);
            if (pathToEnclosing == null) {
                return false;
            }
            Tree enclosing = (Tree)this.clazz.cast(pathToEnclosing.getLeaf());
            return this.matcher.matches(enclosing, state.withPath(pathToEnclosing));
        }
    }
}

