/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;

public record Replacement(Range<Integer> range, String replaceWith) {
    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        Preconditions.checkArgument((startPosition >= 0 && startPosition <= endPosition ? 1 : 0) != 0, (String)"invalid replacement: [%s, %s) (%s)", (Object)startPosition, (Object)endPosition, (Object)replaceWith);
        return new Replacement((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)), replaceWith);
    }

    public int startPosition() {
        return (Integer)this.range().lowerEndpoint();
    }

    public int length() {
        return this.endPosition() - this.startPosition();
    }

    public int endPosition() {
        return (Integer)this.range().upperEndpoint();
    }

    Replacement withDifferentText(String replaceWith) {
        return new Replacement(this.range(), replaceWith);
    }
}

