/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathValues;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.cfg.visualize.CFGVisualizer;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.jspecify.annotations.Nullable;

public record AccessPathStore<V extends AbstractValue<V>>(ImmutableMap<AccessPath, V> heap) implements Store<AccessPathStore<V>>,
AccessPathValues<V>
{
    private static final AccessPathStore<?> EMPTY = new AccessPathStore(ImmutableMap.of());

    public static <V extends AbstractValue<V>> AccessPathStore<V> empty() {
        return EMPTY;
    }

    private @Nullable V getInformation(AccessPath ap) {
        return (V)((AbstractValue)this.heap().get(Preconditions.checkNotNull((Object)ap)));
    }

    public Builder<V> toBuilder() {
        return new Builder(this);
    }

    @Override
    public V valueOfAccessPath(AccessPath path, V defaultValue) {
        V result = this.getInformation(path);
        return result != null ? result : defaultValue;
    }

    public AccessPathStore<V> copy() {
        return this;
    }

    public AccessPathStore<V> leastUpperBound(AccessPathStore<V> other) {
        ImmutableMap.Builder resultHeap = ImmutableMap.builder();
        for (AccessPath aPath : Sets.intersection((Set)this.heap().keySet(), (Set)other.heap().keySet())) {
            resultHeap.put((Object)aPath, (Object)((AbstractValue)this.heap().get((Object)aPath)).leastUpperBound((AbstractValue)other.heap().get((Object)aPath)));
        }
        return new AccessPathStore<V>(resultHeap.buildOrThrow());
    }

    public AccessPathStore<V> widenedUpperBound(AccessPathStore<V> vAccessPathStore) {
        return this.leastUpperBound(vAccessPathStore);
    }

    public boolean canAlias(JavaExpression a, JavaExpression b) {
        return true;
    }

    public String visualize(CFGVisualizer<?, AccessPathStore<V>, ?> cfgVisualizer) {
        throw new UnsupportedOperationException("DOT output not supported");
    }

    public static final class Builder<V extends AbstractValue<V>> {
        private final Map<AccessPath, V> heap;

        Builder(AccessPathStore<V> prototype) {
            this.heap = new LinkedHashMap<AccessPath, V>(prototype.heap());
        }

        @CanIgnoreReturnValue
        public Builder<V> setInformation(AccessPath aPath, V value) {
            this.heap.put((AccessPath)Preconditions.checkNotNull((Object)aPath), (AbstractValue)Preconditions.checkNotNull(value));
            return this;
        }

        public AccessPathStore<V> build() {
            return new AccessPathStore(ImmutableMap.copyOf(this.heap));
        }
    }
}

