/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.ControlFlowVisitor;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.PlaceholderMethod;
import com.google.errorprone.refaster.PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.PlaceholderVerificationVisitor;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import java.util.Optional;

record UPlaceholderStatement(PlaceholderMethod placeholder, ImmutableMap<UVariableDecl, UExpression> arguments, ControlFlowVisitor.Result implementationFlow) implements UStatement
{
    static UPlaceholderStatement create(PlaceholderMethod placeholder, Iterable<? extends UExpression> arguments, ControlFlowVisitor.Result implementationFlow) {
        ImmutableList placeholderParams = placeholder.parameters().asList();
        ImmutableList argumentsList = ImmutableList.copyOf(arguments);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < placeholderParams.size(); ++i) {
            builder.put((Object)((UVariableDecl)placeholderParams.get(i)), (Object)((UExpression)argumentsList.get(i)));
        }
        return new UPlaceholderStatement(placeholder, (ImmutableMap<UVariableDecl, UExpression>)builder.buildOrThrow(), implementationFlow);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OTHER;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitOther(this, data);
    }

    public boolean reverify(Unifier unifier) {
        return (Boolean)MoreObjects.firstNonNull((Object)((Boolean)new PlaceholderVerificationVisitor(Collections2.transform(this.placeholder().requiredParameters(), (Function)Functions.forMap(this.arguments())), (Collection<? extends UExpression>)this.arguments().values()).scan((Iterable<Tree>)unifier.getBinding(this.placeholder().blockKey()), unifier)), (Object)true);
    }

    public Choice<UStatement.UnifierWithUnconsumedStatements> apply(UStatement.UnifierWithUnconsumedStatements initState) {
        StatementTree targetStatement;
        PlaceholderUnificationVisitor visitor = PlaceholderUnificationVisitor.create(TreeMaker.instance(initState.unifier().getContext()), this.arguments());
        PlaceholderVerificationVisitor verification = new PlaceholderVerificationVisitor(Collections2.transform(this.placeholder().requiredParameters(), (Function)Functions.forMap(this.arguments())), (Collection<? extends UExpression>)this.arguments().values());
        Choice<Object> realOptions = Choice.none();
        Choice<PlaceholderUnificationVisitor.State<ConsumptionState>> choiceToHere = Choice.of(PlaceholderUnificationVisitor.State.create(List.nil(), initState.unifier(), ConsumptionState.empty()));
        if (verification.allRequiredMatched()) {
            realOptions = choiceToHere.concat(realOptions);
        }
        UnmodifiableIterator unmodifiableIterator = initState.unconsumedStatements().iterator();
        while (unmodifiableIterator.hasNext() && verification.scan((Tree)(targetStatement = (StatementTree)unmodifiableIterator.next()), initState.unifier()).booleanValue()) {
            choiceToHere = choiceToHere.flatMap(consumptionState -> visitor.unifyStatement(targetStatement, (PlaceholderUnificationVisitor.State<?>)consumptionState).map(stmtState -> stmtState.withResult(((ConsumptionState)consumptionState.result()).consume((JCTree.JCStatement)stmtState.result()))));
            if (!verification.allRequiredMatched()) continue;
            realOptions = choiceToHere.concat(realOptions);
        }
        return realOptions.mapIfPresent(consumptionState -> {
            if (ImmutableSet.copyOf(consumptionState.seenParameters()).containsAll(this.placeholder().requiredParameters())) {
                Unifier resultUnifier = consumptionState.unifier().fork();
                int nConsumedStatements = ((ConsumptionState)consumptionState.result()).consumedStatements();
                ImmutableList remainingStatements = initState.unconsumedStatements().subList(nConsumedStatements, initState.unconsumedStatements().size());
                UStatement.UnifierWithUnconsumedStatements result = UStatement.UnifierWithUnconsumedStatements.create(resultUnifier, (java.util.List<? extends StatementTree>)remainingStatements);
                List<JCTree.JCStatement> impl = ((ConsumptionState)consumptionState.result()).placeholderImplInReverseOrder().reverse();
                ControlFlowVisitor.Result implFlow = ControlFlowVisitor.INSTANCE.visitStatements(impl);
                if (implFlow == this.implementationFlow()) {
                    List<JCTree.JCStatement> prevBinding = resultUnifier.getBinding(this.placeholder().blockKey());
                    if (prevBinding != null && prevBinding.toString().equals(impl.toString())) {
                        return Optional.of(result);
                    }
                    if (prevBinding == null) {
                        resultUnifier.putBinding(this.placeholder().blockKey(), impl);
                        return Optional.of(result);
                    }
                }
            }
            return Optional.empty();
        });
    }

    @Override
    public List<JCTree.JCStatement> inlineStatements(Inliner inliner) throws CouldNotResolveImportException {
        try {
            Optional<List<JCTree.JCStatement>> binding = inliner.getOptionalBinding(this.placeholder().blockKey());
            Optional<JCTree.JCExpression> exprBinding = inliner.getOptionalBinding(this.placeholder().exprKey());
            binding = binding.or(() -> exprBinding.map(expr -> switch (this.implementationFlow()) {
                case ControlFlowVisitor.Result.NEVER_EXITS -> List.of(inliner.maker().Exec((JCTree.JCExpression)expr));
                case ControlFlowVisitor.Result.ALWAYS_RETURNS -> List.of(inliner.maker().Return((JCTree.JCExpression)expr));
                default -> throw new AssertionError();
            }));
            return UPlaceholderExpression.copier(this.arguments(), inliner).copy(binding.get(), inliner);
        }
        catch (UPlaceholderExpression.UncheckedCouldNotResolveImportException e) {
            throw e.getCause();
        }
    }

    record ConsumptionState(int consumedStatements, List<JCTree.JCStatement> placeholderImplInReverseOrder) {
        static ConsumptionState empty() {
            return new ConsumptionState(0, List.nil());
        }

        ConsumptionState consume(JCTree.JCStatement impl) {
            return new ConsumptionState(this.consumedStatements() + 1, this.placeholderImplInReverseOrder().prepend(impl));
        }
    }
}

