/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_UClassType;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.Unifier;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;

@AutoValue
public abstract class UClassType
extends UType {
    public static UClassType create(CharSequence fullyQualifiedClass, List<UType> typeArguments) {
        return new AutoValue_UClassType(StringName.of(fullyQualifiedClass), (ImmutableList<UType>)ImmutableList.copyOf(typeArguments));
    }

    public static UClassType create(String fullyQualifiedClass, UType ... typeArguments) {
        return UClassType.create((CharSequence)fullyQualifiedClass, (List<UType>)ImmutableList.copyOf((Object[])typeArguments));
    }

    abstract StringName fullyQualifiedClass();

    abstract ImmutableList<UType> typeArguments();

    @Override
    public Choice<Unifier> visitClassType(Type.ClassType classType, Unifier unifier) {
        return this.fullyQualifiedClass().unify(classType.tsym.getQualifiedName(), unifier).flatMap(Unifier.unifications(this.typeArguments(), classType.getTypeArguments()));
    }

    @Override
    public Type.ClassType inline(Inliner inliner) throws CouldNotResolveImportException {
        Symbol.ClassSymbol classSymbol = inliner.resolveClass(this.fullyQualifiedClass());
        boolean isNonStaticInnerClass = classSymbol.owner instanceof Symbol.ClassSymbol && (classSymbol.flags() & 8L) == 0L;
        Type.JCNoType owner = isNonStaticInnerClass ? classSymbol.owner.type : Type.noType;
        return new Type.ClassType(owner, inliner.inlineList(this.typeArguments()), classSymbol);
    }
}

