/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.refaster.AutoValue_BlockTemplate;
import com.google.errorprone.refaster.BlockTemplateMatch;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.ExpressionTemplate;
import com.google.errorprone.refaster.ImportPolicy;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.refaster.annotation.UseImportPolicy;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Warner;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

@AutoValue
public abstract class BlockTemplate
extends Template<BlockTemplateMatch> {
    private static final Logger logger = Logger.getLogger(BlockTemplate.class.toString());

    public static BlockTemplate create(UStatement ... templateStatements) {
        return BlockTemplate.create((Map<String, ? extends UType>)ImmutableMap.of(), templateStatements);
    }

    public static BlockTemplate create(Map<String, ? extends UType> expressionArgumentTypes, UStatement ... templateStatements) {
        return BlockTemplate.create((Iterable<UTypeVar>)ImmutableList.of(), expressionArgumentTypes, templateStatements);
    }

    public static BlockTemplate create(Iterable<UTypeVar> typeVariables, Map<String, ? extends UType> expressionArgumentTypes, UStatement ... templateStatements) {
        return BlockTemplate.create((ImmutableClassToInstanceMap<Annotation>)ImmutableClassToInstanceMap.of(), typeVariables, expressionArgumentTypes, (Iterable<? extends UStatement>)ImmutableList.copyOf((Object[])templateStatements));
    }

    public static BlockTemplate create(ImmutableClassToInstanceMap<Annotation> annotations, Iterable<UTypeVar> typeVariables, Map<String, ? extends UType> expressionArgumentTypes, Iterable<? extends UStatement> templateStatements) {
        return new AutoValue_BlockTemplate(annotations, (ImmutableList<UTypeVar>)ImmutableList.copyOf(typeVariables), (ImmutableMap<String, UType>)ImmutableMap.copyOf(expressionArgumentTypes), (ImmutableList<UStatement>)ImmutableList.copyOf(templateStatements));
    }

    public BlockTemplate withStatements(Iterable<? extends UStatement> templateStatements) {
        return BlockTemplate.create(this.annotations(), this.templateTypeVariables(), this.expressionArgumentTypes(), templateStatements);
    }

    abstract ImmutableList<UStatement> templateStatements();

    @Override
    public Iterable<BlockTemplateMatch> match(JCTree tree, Context context) {
        if (tree instanceof JCTree.JCBlock) {
            JCTree.JCBlock block = (JCTree.JCBlock)tree;
            ImmutableList targetStatements = ImmutableList.copyOf((Collection)block.getStatements());
            return this.matchesStartingAnywhere(block, 0, (ImmutableList<? extends StatementTree>)targetStatements, context).findFirst().orElse(List.nil());
        }
        return ImmutableList.of();
    }

    private Choice<List<BlockTemplateMatch>> matchesStartingAtBeginning(JCTree.JCBlock block, int offset, ImmutableList<? extends StatementTree> statements, Context context) {
        if (statements.isEmpty()) {
            return Choice.none();
        }
        JCTree.JCStatement firstStatement = (JCTree.JCStatement)statements.getFirst();
        Choice<UStatement.UnifierWithUnconsumedStatements> choice = Choice.of(UStatement.UnifierWithUnconsumedStatements.create(new Unifier(context), statements));
        for (UStatement templateStatement : this.templateStatements()) {
            choice = choice.flatMap(templateStatement);
        }
        return choice.flatMap(state -> {
            Unifier unifier = state.unifier();
            Inliner inliner = unifier.createInliner();
            try {
                Optional<Unifier> checkedUnifier = this.typecheck(unifier, inliner, new Warner(firstStatement), this.expectedTypes(inliner), this.actualTypes(inliner));
                if (checkedUnifier.isPresent()) {
                    int consumedStatements = statements.size() - state.unconsumedStatements().size();
                    BlockTemplateMatch match = new BlockTemplateMatch(block, checkedUnifier.get(), offset, offset + consumedStatements);
                    boolean verified = ExpressionTemplate.trueOrNull(ExpressionTemplate.PLACEHOLDER_VERIFIER.scan((Iterable<Tree>)this.templateStatements(), checkedUnifier.get()));
                    if (!verified) {
                        return Choice.none();
                    }
                    return this.matchesStartingAnywhere(block, offset + consumedStatements, (ImmutableList<? extends StatementTree>)statements.subList(consumedStatements, statements.size()), context).map(list -> list.prepend(match));
                }
            }
            catch (CouldNotResolveImportException couldNotResolveImportException) {
                // empty catch block
            }
            return Choice.none();
        });
    }

    private Choice<List<BlockTemplateMatch>> matchesStartingAnywhere(JCTree.JCBlock block, int offset, ImmutableList<? extends StatementTree> statements, Context context) {
        Choice<List<Object>> choice = Choice.none();
        for (int i = 0; i < statements.size(); ++i) {
            choice = choice.concat(this.matchesStartingAtBeginning(block, offset + i, (ImmutableList<? extends StatementTree>)statements.subList(i, statements.size()), context));
        }
        return choice.concat(Choice.of(List.nil()));
    }

    private static String printStatement(Context context, JCTree.JCStatement statement) {
        StringWriter writer = new StringWriter();
        try {
            BlockTemplate.pretty(context, writer).printStat(statement);
        }
        catch (IOException e) {
            throw new AssertionError("StringWriter cannot throw IOExceptions", e);
        }
        return writer.toString();
    }

    private static String printStatements(Context context, Iterable<JCTree.JCStatement> statements) {
        StringWriter writer = new StringWriter();
        try {
            BlockTemplate.pretty(context, writer).printStats(List.from(statements));
        }
        catch (IOException e) {
            throw new AssertionError("StringWriter cannot throw IOExceptions", e);
        }
        return writer.toString();
    }

    @Override
    public Fix replace(BlockTemplateMatch match) {
        Preconditions.checkNotNull((Object)match);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Inliner inliner = match.createInliner();
        Context context = inliner.getContext();
        if (this.annotations().containsKey(UseImportPolicy.class)) {
            ImportPolicy.bind(context, ((UseImportPolicy)this.annotations().getInstance(UseImportPolicy.class)).value());
        } else {
            ImportPolicy.bind(context, ImportPolicy.IMPORT_TOP_LEVEL);
        }
        ImmutableList<JCTree.JCStatement> targetStatements = match.getStatements();
        try {
            int nTargets;
            ImmutableList.Builder inlinedStatementsBuilder = ImmutableList.builder();
            for (UStatement statement : this.templateStatements()) {
                inlinedStatementsBuilder.addAll(statement.inlineStatements(inliner));
            }
            ImmutableList inlinedStatements = inlinedStatementsBuilder.build();
            int nInlined = inlinedStatements.size();
            if (nInlined <= (nTargets = targetStatements.size())) {
                int i;
                for (i = 0; i < nInlined; ++i) {
                    fix.replace((Tree)targetStatements.get(i), BlockTemplate.printStatement(context, (JCTree.JCStatement)inlinedStatements.get(i)));
                }
                for (i = nInlined; i < nTargets; ++i) {
                    fix.delete((Tree)targetStatements.get(i));
                }
            } else {
                for (int i = 0; i < nTargets - 1; ++i) {
                    fix.replace((Tree)targetStatements.get(i), BlockTemplate.printStatement(context, (JCTree.JCStatement)inlinedStatements.get(i)));
                }
                int last = nTargets - 1;
                ImmutableList remainingInlined = inlinedStatements.subList(last, nInlined);
                fix.replace((Tree)targetStatements.get(last), CharMatcher.whitespace().trimTrailingFrom((CharSequence)BlockTemplate.printStatements(context, (Iterable<JCTree.JCStatement>)remainingInlined)));
            }
        }
        catch (CouldNotResolveImportException e) {
            logger.log(Level.SEVERE, "Failure to resolve import in replacement", e);
        }
        return BlockTemplate.addImports(inliner, fix);
    }
}

